/*
 * Program to print first sentence of each paragraph/section/chapter, to
 * allow one to skim the contents of a long document.  A sentence is
 * recognized as a line containing ".  " or ending in "." (the same
 * algorithm as vi(1) uses).  By Mike Schwartz, 4-29-87.
 *
 * Usage: skim [filename]
 * 
 *  skim.c,v 1.3 1994/12/08 23:47:07 hardy Exp
 */
#include <stdio.h>
#include <string.h>
#define MAX_CHARS_PER_LINE 1024
#define MAX_LINES 512	/* bailout if sent. aren't recog. or long docs */

int Argc;
char **Argv;
FILE *InputFile = stdin;

main(argc, argv)
int argc;
char **argv;
{
	char LineBuf[MAX_CHARS_PER_LINE];
	int Skipping = 0, nlines = 0;
	char *Ptr;
	char *EndLine;

	/* Set up globals */
	Argc = argc;
	Argv = argv;

	if (Argc > 1)
		OpenNextFile();

	do {	/* Read lines */
		if (nlines > MAX_LINES)
			exit(0);
		if (fgets(LineBuf, MAX_CHARS_PER_LINE, InputFile) == NULL) 
			OpenNextFile();
		if (IsSectDelim(LineBuf)) {
			fputs(LineBuf, stdout);
			nlines++;
			Skipping = 0;
			continue;
		}
		if (Skipping)
			continue;
		fputs(LineBuf, stdout);
		nlines++;
                EndLine = &LineBuf[strlen(LineBuf) - 2]; /*
                                                          * Character
                                                          * before carriage
                                                          * return
							  */

		/* 
                 * Look for a ".  " in the middle of the line (end of
                 * sentence)
		 */
		for (Ptr = LineBuf; Ptr < EndLine - 2; Ptr++)
			if (strncmp(Ptr, ".  ", 3) == 0)
				Skipping = 1;
		/* Look for a '.' at end of the line (end of sentence) */
		if (*EndLine == '.')
			Skipping = 1;
		if (Skipping)
			puts("...");
	} while(1);
}

IsSectDelim(Str)
char *Str;
{
	static char *SectDelims[] = {
		".LP",
		".PP",
		".S#",
		".Ch",
		".SH",
		".NH",
		".lp",
		".pp",
		".sh",
		"\n",
		NULL
	};
	int i;

	for (i = 0; SectDelims[i] != NULL; i++)
		if (strncmp(Str, SectDelims[i], 3) == 0)
			return(1);
	
	return(0);
}

OpenNextFile()
{
	if (Argc == 1)
		exit(0);
	if (strcmp(Argv[1], "-") == 0)
		InputFile = stdin;
	else
		InputFile = fopen(Argv[1], "r");
	if (InputFile == NULL) {
		perror("skim: fopen");
		exit(1);
	}
	Argv++;
	Argc--;
}
