
/*
 * (c) Copyright 1993 by Panagiotis Tsirigotis
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

/*
 * defs.h,v 1.2 1994/05/12 18:44:48 hardy Exp
 */

#define PRIVATE							static

#ifndef FALSE
#define FALSE								0
#endif
#ifndef TRUE
#define TRUE								1
#endif

#ifndef NULL
#define NULL								0
#endif

#define NUL									'\0'
#define SPACE								' '
#define NEWLINE							'\n'
#define CARRIAGE_RETURN					'\015'
#define TAB									'\t'
#define BACKSLASH							'\\'
#define OPEN_PAREN						'('
#define CLOSE_PAREN						')'
#define OPEN_CURLY_BRACKET				'{'
#define CLOSED_CURLY_BRACKET			'}'
#define OPEN_BRACKET						'['
#define CLOSED_BRACKET					']'
#define LESS_THAN							'<'
#define GREATER_THAN						'>'
#define MINUS								'-'
#define SLASH								'/'

typedef enum {
	TOK_STRING, TOK_NUMBER, TOK_OTHER, TOK_CMD
} token_e;

void error();
void printout();

extern int line_count;

#define NUM( c )							( (c) - '0' )

#define NEXT_CHAR( fd, c )				{									\
													c = Sgetchar( fd ) ;		\
													if ( c == NEWLINE )		\
														line_count++ ;			\
												}

#define PUTBACK( fd, c )         {                                \
                                    Sundo( fd, SIO_UNDO_CHAR ) ;  \
                                    if ( c == NEWLINE )           \
                                       line_count-- ;             \
                                 }
