: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  

$usage = "usage: $0 oldcachedir newcachedir oldlog\n";


$olddir = shift			|| die $usage;
$newdir = shift			|| die $usage;

mkdir ($newdir, 0775);
foreach $f (0..99) {
	$d = sprintf ("$newdir/%02d", $f);
	mkdir ($d, 0775)	|| die "$d: $!\n";
}

$now = time;

$newlog = "$newdir/log";
open (newlog, ">$newlog")	|| die "$newlog: $!\n";

$oldlog = "$olddir/log";
open oldlog			|| die "$oldlog: $!\n";
while (<oldlog>) {
	next unless (/FILE:\s+(\S+)\s+URL:\s+(\S+)\s+(\d+)\s+(\d+)/);
	$file = $1;
	$url  = $2;
	$exp  = $3;
	$tstamp = $4;

	@F = split('/', $file);
	$fileno = pop @F;
	$dirno = sprintf ("%02d", $fileno % 100);
	$oldfile = "$olddir/$dirno/$fileno";

	if ($now > $exp) {
		print "Expired $oldfile\n";
		next;
	}

	unless (@sb = stat($oldfile)) {
		print "$oldfile: $!\n";
		next;
	}

	if ($sb[9] != $tstamp) {
		print "Wrong timestamp on $oldfile\n";
		next;
	}

	$newfile = "$newdir/$dirno/$fileno";

	rename ($oldfile, $newfile)	|| die "rename $newfile: $!\n";
	printf newlog ("FILE: %s URL: %s %d %d\n",
		$newfile,
		$url,
		$exp,
		$tstamp);

}
