/* $Id: statistics.c,v 1.3 1995/05/11 16:17:08 dante Exp $ */
#include <stdio.h>
#include <sys/time.h>
#include <siteid.h>
#include <statistics.h>
#include <xmalloc.h>

extern int debug;

/*
 * Statistics
 */

#define alpha 0.5
/* Round trip time is in milliseconds */

Statistics *
statistics_new (SiteID id)
{
  Statistics *stat;

  stat = xmalloc (sizeof (Statistics));
  stat->id = id;
  stat->bandwidth = NOTSET;
  stat->round_trip_time = NOTSET;
  return (stat);
}

void
statistics_free (Statistics *stat)
{
  xfree (stat);
}

void
statistics_update_rtt (Statistics *stat, struct timeval time)
{
  int rtt;

  rtt = time.tv_sec * 1000 + time.tv_usec / 1000;

  if (stat->round_trip_time == NOTSET)
    stat->round_trip_time = rtt;
  else
    stat->round_trip_time =
      alpha * stat->round_trip_time + (1.0 - alpha) * rtt;
}

void
statistics_update_bandwidth (Statistics *stat, int size, struct timeval time)
{
  int bandwidth = 
    (int) (1000000L * 
	   ((double) size / (double) (time.tv_sec * 1000000L + time.tv_usec)));

      if (debug)
      {
	  fprintf (stderr, "Bandwidth from `%d.%d.%d.%d:%d' of %u byte/sec\n",
		   stat->id.addr.bytes[0], 
		   stat->id.addr.bytes[1], 
		   stat->id.addr.bytes[2], 
		   stat->id.addr.bytes[3], 
		   stat->id.port.port, 
		   bandwidth);
      }

  if (stat->bandwidth == NOTSET)
    stat->bandwidth = bandwidth;
  else
    stat->bandwidth =
      alpha * stat->bandwidth + (1.0 - alpha) * bandwidth;
}

int
statistics_compare (Statistics *a, Statistics *b)
{
  return (siteid_compare (&a->id, &b->id));
}


int
statistics_by_id (SiteID *id, Statistics *b)
{
  return (siteid_compare (id, &b->id));
}
