#ifndef _SITEINFO_H_
#define _SITEINFO_H_
#include <statistics.h>
#include <list.h>
/* Status for connection */
#define STATUS_MAX 3
#define STATUS_DOWN 0

typedef struct _SiteInfo
{
  char *name;
  SiteID id;

  char *host;
  char *inetaddr;		/* hint for inetaddress (e.g. 128.111.41.47)*/
  struct sockaddr_in *address;	/* udp address */
  int address_length;
  int data_port;		/* inter-floodd commnication */
  int client_port;		/* port on which client communicate */
  int status;			/* Is this site up or down. 
				 * An increment for each packet received
				 * and periodic decrement.
				 */

  int sequence_number;		/* last sequence number received from this
				 *  site 
				 */

  List *estimates;		/* Ping & BW estimations received from
				 * this site to all other sites.
				 */

  Queue *datablocks_to_send;	/* A queue of datablocks to be send to
				 * this site.  If the site is the local
				 * site, then the queue is used to store
				 * datablocks for flooding once a topology
				 * comes in.
				 */
  MessageLog *acks;		/* Acked datablocks */
  float longitude;		/* longitude of site */
  float lattitude;		/* lattitude of site */
  int sender_fd;		/* The file descriptor of the current
				 * connection to this site.
				 */
  int last_heard_from;		/* The last time we heard from this site */
  int ping_sent:2;		/* have we pinged the site recently */
  int bw_estimate_sent:2;	/* have we sent a bw estimate recently */
} SiteInfo;

SiteInfo *
siteinfo_new (char *name);

void
siteinfo_delete (SiteInfo *siteinfo);

void
siteinfo_set_address (SiteInfo *site);

int
siteinfo_compare (SiteInfo *a, SiteInfo *b);


#ifdef NEVER
SiteInfo *
siteinfo_read (FILE *file, Group **group);
#endif

void
siteinfo_print (SiteInfo *siteinfo, FILE *file);

SiteInfo *
site_by_address (struct sockaddr_in *from);

SiteInfo *
site_by_name (char *name);

SiteInfo *
site_by_id (SiteID *id);

void
siteinfo_receive_ack (SiteInfo *site, MessageID *ack);

void
siteinfo_ack (MessageID *ack);

#define NOTSET -1

#endif /* _SITEINFO_H_ */
