/* $Id: siteinfo.c,v 1.2 1995/07/25 20:08:36 dante Exp $ */
#include <stdio.h>
#include <math.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#if defined (HAVE_SYSLOG_H)
#  include <syslog.h>
#endif /* !SYS_SYSLOG */
#include <netdb.h>
#include <floodd.h>
#include <dynamic_string.h>

/*
 * Site manipulation.
 */

SiteInfo *
siteinfo_new (char *name)
{
  SiteInfo *siteinfo;
  struct timeval current;

  siteinfo = xmalloc (sizeof (SiteInfo));

  siteinfo->name = name;
  siteinfo->host = NULL;
  siteinfo->inetaddr = NULL;
  siteinfo->data_port = NOTSET;
  siteinfo->client_port = NOTSET;
  siteinfo->status = 1;		/* give the site the benefit of the doubt */
  siteinfo->address = NULL;
  siteinfo->address_length = 0;
  
  siteinfo->id.addr.addr = 0;
  siteinfo->id.port.port = NOTSET;

  siteinfo->estimates = LIST_NEW (NULL, statistics_compare);

  siteinfo->datablocks_to_send = queue_new ();

  siteinfo->acks = messagelog_new ();

  siteinfo->lattitude = 0.0;
  siteinfo->longitude = 0.0;

  siteinfo->sender_fd = NOTSET;;

  current = timeval_current ();
  siteinfo->last_heard_from = current.tv_sec;
  siteinfo->ping_sent = 0;
  siteinfo->bw_estimate_sent = 0;
  return (siteinfo);
}

void
siteinfo_free (SiteInfo *siteinfo)
{
  xfree (siteinfo->name);
  xfree (siteinfo->address);
  list_free (siteinfo->estimates);
  QUEUE_RESET (siteinfo->datablocks_to_send, datablock_free);
  xfree (siteinfo);
}

void
siteinfo_print (SiteInfo *siteinfo, FILE *file)
{
  fprintf (file, "%s host:%s data:%d status:%d\n",
	   siteinfo->name,
	   siteinfo->host,siteinfo->data_port,
	   siteinfo->status);
}

void
siteinfo_set_address (SiteInfo *site)
{
  if (site->address)
    xfree (site->address);

  site->address = (struct sockaddr_in *)
    inet_sockaddr ((site->inetaddr == NULL)  
		   ? site->host : site->inetaddr,
		   site->data_port);
  if (site->address != NULL)
    {
      site->address_length = sizeof (struct sockaddr_in);
  
      /* Now set the id info (address,port) */
      memcpy (site->id.addr.bytes, &site->address->sin_addr.s_addr,
	     sizeof (site->address->sin_addr.s_addr));
      site->id.port.port = htons (site->data_port);
    }

  /* Set up the site's inetaddr address, if it has not been set */
  if (site->inetaddr == NULL)
    {
      string_declare (address);
      string_init (address, 17);
      string_append_address (address, site->id.addr.bytes);
      site->inetaddr = address;
    }
}


/********* These functions should be renamed */

SiteInfo *
site_by_address (struct sockaddr_in *from)
{
  SiteInfo **sitep;

  for (sitep = sites; sitep != NULL && *sitep !=  NULL; sitep++)
    if ((from->sin_addr.s_addr == (*sitep)->address->sin_addr.s_addr) &&
	(from->sin_port == (*sitep)->address->sin_port))
      return (*sitep);
  return (NULL);
}

SiteInfo *
site_by_name (char *name)
{
  int i;

  for (i = 0; sites != NULL && sites[i] != NULL; i++)
    if (strcmp (name, sites[i]->name) == 0)
      return (sites[i]);
  return (NULL);
}

SiteInfo *
site_by_id (SiteID *id)
{
  int i;

  for (i = 0; sites != NULL && sites[i] != NULL; i++)
    if (id->addr.addr == sites[i]->id.addr.addr &&
	id->port.port == sites[i]->id.port.port)
      return (sites[i]);

  /* That didn't work so lets look for the address and the other port number */
  for (i = 0; sites != NULL && sites[i] != NULL; i++)
    if (sites[i]->address->sin_addr.s_addr == id->addr.addr &&
	sites[i]->client_port == ntohs(id->port.port))
      return (sites[i]);

  return (NULL);
}


/* Just send a data gram off to another site - don't wait for a reply */
void
site_send_message (SiteInfo *site, void *message, int message_length)
{
  int result;
  extern ping_socket;

  result = sendto (ping_socket, message, message_length, 0,
		   (struct sockaddr *) site->address, site->address_length);
  if (result < 0 && debug)
    {
      syslog (LOG_DEBUG,
	      "site_send_message(): Error sending message to %s:%s : %m",
	      site->name, site->host);
    }
}

int
siteinfo_compare (SiteInfo *a, SiteInfo *b)
{
  return (siteid_compare (&a->id, &b->id));
}

/* Process an ACK for a datablock from a neighboring site 
 * 1) Put on ACK queue
 * 2) Remove datablock if on send queue.
 */
void
siteinfo_receive_ack (SiteInfo *site, MessageID *ack)
{
  int datablock_compare (void *, void *);
  DataBlock *datablock;

  if (debug)
    {
      printf ("Processing ACK: %s:%u:%u\n",
	      siteid_to_string (&ack->site), 
	      ntohl (ack->time.tv_sec),
	      ntohl (ack->time.tv_usec));
    }

  messagelog_log (site->acks, ack);

  datablock = 
    queue_find_element (site->datablocks_to_send, ack, datablock_compare);

  /* We don't want to remove the first block on the queue because it
   * may be being sent to this site.  We let the data_connection_write
   * func worry about that.
   */
  if (datablock != NULL && 
      (datablock != queue_head (site->datablocks_to_send)))
    {
      printf ("Processing ACK: Removed Datablock %s:%u:%u\n",
	      siteid_to_string (&ack->site), 
	      ntohl (ack->time.tv_sec),
	      ntohl (ack->time.tv_usec));
      queue_delete_element (site->datablocks_to_send, datablock);
      datablock_free (datablock);
    }
}

/* Send out an ack for a datablock.  Acks get sent to all neighbors.
 */
void
siteinfo_ack (MessageID *ack)
{
  int i, j, k;

  for (i = 0; groups[i] != NULL; i++)
    for (j = 0; groups[i]->neighbors && groups[i]->neighbors[j]; j++)
      send_ack (groups[i]->neighbors[j], ack);
}
