/* $Id: queue.h,v 1.2 1995/04/22 22:26:47 dante Exp $ */
#ifndef _QUEUE_H_
#define _QUEUE_H_

typedef struct _queue_element
{
  void *value;
  struct _queue_element *next;
} QueueElement;

typedef struct
{
  int size;
  QueueElement  queue;
  QueueElement *tail;
} Queue;

typedef int QueueCompare (void *a, void *b);

Queue *
queue_new ();

void
queue_free (Queue *queue, void element_free (void *));

void 
queue_insert (Queue *queue, void *element);

void *
queue_remove (Queue *queue);

void *
queue_head (Queue *queue);

int
queue_empty (Queue *queue);

void
queue_reset (Queue *queue, void element_free (void *));

void *
queue_delete_element (Queue *queue, void *value);

void *
queue_find_element (Queue *queue, void *value, QueueCompare *compare);

#define QUEUE_RESET(queue, func) queue_reset (queue, (void*) func)
#define QUEUE_FREE(queue, func) queue_free (queue, (void*) func)
#endif
