/* $Id: queue.c,v 1.2 1995/04/22 22:25:57 dante Exp $ */
#include <stdio.h>
#include <xmalloc.h>
#include <queue.h>


QueueElement *
queueelement_new (void *value)
{
  QueueElement *element;

  element = xmalloc (sizeof (QueueElement));
  element->value = value;
  element->next = NULL;
  return (element);
}

void
queueelement_free (QueueElement *element)
{
  xfree (element);
}

Queue *
queue_new ()
{
  Queue *queue;
  
  queue = xmalloc (sizeof (Queue));
  queue->size = 0;
  queue->queue.next = NULL;
  queue->queue.value = NULL;
  queue->tail = &queue->queue;

  return (queue);
}

void
queue_reset (Queue *queue, void element_free (void *))
{
  void *element;
  while (!queue_empty (queue))
    {
      element = queue_remove (queue);
      if (element_free != NULL)
	element_free (element);
    }
}

void
queue_free (Queue *queue, void element_free (void *))
{
  queue_reset (queue, element_free);
  xfree (queue);
}

void 
queue_insert (Queue *queue, void *value)
{
  QueueElement *element;

  if (value == NULL)
    {
      abort ();
    }

  queue->size++;
  element = queueelement_new (value);
  queue->tail->next = element; 
  queue->tail = element;
}

void *
queue_remove (Queue *queue)
{
  QueueElement *element;
  void *result;

  if (queue_empty (queue))
    return (NULL);
  
  queue->size--;
  element = queue->queue.next;
  queue->queue.next = element->next;

  if (queue->queue.next == NULL)
    queue->tail = &queue->queue;

  result = element->value;

  queueelement_free (element);
  return (result);
}

void *
queue_find_element (Queue *queue, void *value, QueueCompare *compare)
{
  QueueElement *element;

  if (queue_empty (queue))
    return (NULL);

  element = queue->queue.next;

  while (element != NULL)
    {
      if (compare (value, element->value) == 0)
	return (element->value);
      element = element->next;
    }
  return (NULL);
}

/* Delete an element from anywhere in the queue */
void *
queue_delete_element (Queue *queue, void *value)
{
  QueueElement *prev_element;
  QueueElement *element;

  if (queue_empty (queue))
    return (value);

  prev_element = &queue->queue;

  while (prev_element->next != NULL)
    {
      if (prev_element->next->value == value)
	break;
      prev_element = prev_element->next;
    }

  if (prev_element->next == NULL)
    return (NULL);

  element = prev_element->next;
  queue->size--;
  prev_element->next = element->next;
  if (queue->tail == element)
    queue->tail = prev_element;

  queueelement_free (element);
  return (value);
}

/* Return the first element in the queue, but don't remote it
 * from the queue.
 */

void *
queue_head (Queue *queue)
{
  if (!queue_empty (queue))
    return (queue->queue.next->value);
  return (NULL);
}

int
queue_empty (Queue *queue)
{
  return (queue->size == 0);
}
