#ifndef _LIST_H_
#define _LIST_H_
#ifndef NULL
#define NULL ((void *) 0)
#endif

typedef int CompareFunc (void *key, void *element);
typedef int FreeFunc    (void *element);

typedef struct _List List;

struct _List
{
  int count;                    /* number of elements current in list */
  int max;                      /* number of slots allocated in list */
  void *null;                   /* the null element for this list */
  void **list;

#ifdef __STDC__
  void *(*insert) (List *list, void *element);
  void *(*delete) (List *list, void *element);
  void *(*find)   (List *list, void *key, CompareFunc *compare);
  void *(*index)  (List *list, int i);
  void (*zero)    (List *list);
  CompareFunc     *compare;

#else
  void  (*insert) ();
  void *(*delete) ();
  void *(*find)   ();
  void *(*index)  ();
  void (*zero)    ();
  int (*compare)  ();
#endif
};



#ifdef __STDC__
void *
list_insert (List *list, void *element);

void *
list_delete (List *list, void *element);

void *
list_pointer (List *list);

void *
list_index (List *list, int i);

void *
list_find (List *list, void *key, CompareFunc *compare);

void
list_zero (List *list);

List *
list_new (void *null, CompareFunc *compare);

/* $Id: list.h,v 1.2 1995/04/22 21:09:05 dante Exp $ */
void
list_free (List *list);

void
list_free_elements (List *list, FreeFunc *func );

#define LIST_NEW(null, compare) list_new (null, (CompareFunc *) compare)

#define LIST_FIND(list, key, func) list_find (list, key, (CompareFunc *) func)

#define LIST_FREE_ELEMENTS(list, func) list_free_elements (list, (FreeFunc *)func) ;
#else

void *
list_insert ();

void *
list_pointer ();

void *
list_index ();

void *
list_find ();

void
list_zero ();

List *
list_new ();

void
list_free ();

void
list_free_elements ();
#endif

#endif /* _LIST_H_ */
