/* $Id: event.h,v 1.1 1995/04/22 21:47:28 dante Exp $ */
#ifndef _EVENT_H_
#define _EVENT_H_
#include <sys/time.h>

typedef struct
{
  int (*action) ();

  int args_count;
  void **args;

  int delete_funcs_count;
  void (**delete_funcs)();
} Action;

Action *
va_action_new (int (*func)(), va_list ap);

Action *
action_new (int (*func)(), ...);

void
action_delete (Action *action);

int
action_execute (Action *action, int arg_num, void *data);

#define END_OF_ARGS  (void *)-2
#define NOTSET -1
#define FREE_FUNCS (void *) -3

typedef struct
{
  Action *action;
  struct timeval time;
} Event;

Event *
va_event_new (int (*action) (), struct timeval time, va_list ap);

Event *
event_new (int (*action) (), struct timeval time, ...);

Event *
event_free (Event *event);

void
event_insert (Event *event);

Event *
event_post (int (*action) (), struct timeval how_soon, ...);

struct timeval
event_next_time ();

Event *
event_next (void);

extern int events_count;
#endif /* _EVENT_H_ */
