: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  

# -----------------------------------------------------------------
# Config.pl
# 
# Author: Mic Bowman
#
# A perl interface to the config files used by the Transarc common
# library configuration modules.  Each file contains a series of
# lines that contain a variable and the value to be assigned to that
# variable.  Whitespace separates the value from the variable. The
# environment variable CONFIG_PRECONF contains the name of a program
# to apply to the configuration file before it is read.
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# Globals
# -----------------------------------------------------------------
$config_preconf = $ENV{"CONFIGURE_PREPROCESS"};

# -----------------------------------------------------------------
# ReadConfiguration(file,initial)
#
# Read a file of configuration records; add them to the initial
# configuration array.  If necessary, run the preprocessor on the
# configuration file. A typical call looks like this:
#	&ReadConfiguration("test.conf",*TEST);
# -----------------------------------------------------------------
sub ReadConfiguration {
    local($config_file, *CONFIG) = @_;
    
    # Open the configuration file
    if ((defined $config_preconf) && (-x $config_preconf)) {
	open(CFILE,"$config_preconf $config_file|") || 
	    die "Cannot create pipe to process configuration file.\n";
    } else {
	open(CFILE,"<$config_file") ||
	    die "Cannot open configuration file: $config_file.\n";
    }

    # Read the configuration records
    while (<CFILE>) {
	next if (/^\s*!/);	# skip comments
	next if (/^\s*$/);	# skip blank lines
	($var,$val) = /^\s*([a-zA-Z]\S*)\s+(\S.*)\s*$/;
	if ($val =~ /^\"(.*)\"[^\"]*$/) { # "
	    ($val)  = ($val =~ /^\"(.*)\"[^\"]*$/);
	}
	$val =~ s/\\\\/\\--/g;
	$val =~ s/\\e/\033/g;
	$val =~ s/\\n/\n/g;
	$val =~ s/\\r/\r/g;
	$val =~ s/\\t/\t/g;
	$val =~ s/\\--/\\/g;
	    
	$CONFIG{$var} = $val;
    }

    close(CFILE);
}

1
