: # *-*-perl-*-*
    eval 'exec perl -S $0 "$@"'
    if $running_under_some_shell;  

#
#  Reads a gatherer @INFO (stats) SOIF object and writes an HTML page
#
#      gather -info host port | info-to-html.pl > host.port.html
#
#  Assumes only one @INFO object is presented on stdin.
#
#  $Id: info-to-html.pl,v 1.7 1995/03/22 06:37:31 hardy Exp $
#
$ENV{'HARVEST_HOME'} = "/usr/local/harvest" if (!defined($ENV{'HARVEST_HOME'}));
unshift(@INC, "$ENV{'HARVEST_HOME'}/lib");      # use local files 
require 'ctime.pl';
require 'soif.pl';

# Read and parse the SOIF input
#
$soif'input = 'STDIN';
($ttype, $url, %SOIF) = &soif'parse();
exit 1 if ($ttype ne "INFO");
$time0 = &ctime (time);				chop $time0;
$time1 = &ctime ($SOIF{'Min-Update-Time'});	chop $time1;
$time2 = &ctime ($SOIF{'Max-Update-Time'});	chop $time2;

# Write out some HTML
#
print <<EOF;

<TITLE>$SOIF{'Gatherer-Name'} Gatherer Statistics</TITLE>
<H2>Gatherer: $SOIF{'Gatherer-Name'}</H2>
<P>
The Gatherer Host is <B>$SOIF{'Gatherer-Host'}</B>
<P>
The gatherer database contains <B>$SOIF{'Object-Count'}</B> objects collected between
<B>$time1</B> and <B>$time2</B>.
<P>
The following attributes occur in at least 25% of the objects:
<PRE>
EOF
	$N = $SOIF{'Object-Count'};
	if ($N > 0) {
		foreach $_ (split (/\n/, $SOIF{'Attribute-Histogram'})) {
			s/^ // while (/^ /);
			($n, $x) = split;
			print "      $x\n" if ($n / $N >= 0.25);
		}
	}

print <<EOF;
</PRE>
<HR>
Generated $time0
EOF


exit 0;
