# get.pl -- Handle GET requests
#
# $Id: get.pl,v 2.5 1993/06/29 04:56:22 sanders Exp $
#
# by Tony Sanders <sanders@bsdi.com>, April 1993
#

# XXX: should probably handle TEXTSEARCH requests here also

sub do_get {
    local ($_, $version) = @_;
    local ($top, $rest, $query, $map) = (undef, undef, undef, undef);

    #
    # preprocess the request
    #
    s:\?(.*):: && ($query = $1);		# extract query (if any)
    s:.*:/$&/:;	s:/+:/:g;			# force leading and trailing /
    $get_norel && m:/\.+/: && &error('unauthorized',
	    "No backward directory references permitted: $_");
    m:[\<\|\>\`]: && &error('unauthorized',
        "No special characters permitted: $_");
    $_ = "/$http_homepage/" if $_ eq "/";	# special case home page
    s:^/::; s:/$::;				# cleanup
    ($top, $rest) = split("/", $_, 2);

    # We now have:
    #   $_     The simple path (basically $top/$rest)
    #   $top   The first directory level (for matching mapped entries)
    #   $rest  The remainder of path
    #   $query Any query data sent along (data after a question mark)

    alarm($http_timeout); 
    $map = (defined $map{$top}) ? $top : "__default__";
    eval $map{$map}; &error('internal_error', $@) if $@;
}

1;
