//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#define Uses_TProgram
#define Uses_TDeskTop
#include"turlwind.h"

TURLWindow::TURLWindow(const TNSCollection *TNSCp_Hist, const char *cp_URL) :
	TWindow(TProgram::deskTop->getExtent(), NULL, Number()),
	TWindowInit(&TWindow::initFrame)	{
//	Purpose:	Constructor for the URL window, clone version.
//	Arguments:	cp_URL	The url to create the window for.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		03-16-94	created to clone another window.

	//	Set our window options and size
	options |= ofTileable;
	TRect TR = getExtent();
	TR.grow(-1, -1);

	//	No view yet.
	TURLV = NULL;

	//	Create the stack of visited anchors for this window.
	TNSCp_visited = new TNSCollection(1, 1);
	if(TNSCp_visited == NULL)	{
		doslynxmessage("Unable to allocate memory for window.");
		OwnerClose();
	}

	//	Attempt to load the document.
	URLoader(cp_URL);

	//	We have to copy the history into our own visited list here.
	//	Free all names in the current list by simply destroying it.
	destroy(TNSCp_visited);
	//	Recreate the stack of visited anchors for this window.
	TNSCp_visited = new TNSCollection(1, 1);
	if(TNSCp_visited == NULL)	{
		doslynxmessage("Unable to allocate memory for window.");
		OwnerClose();
	}

	//	Copy over the history list.
	auto char *cp_clone;
	for(signed short int ssi_clone = 0; ssi_clone <
		TNSCp_Hist->getCount(); ssi_clone++)	{
		cp_clone = newStr((const char *)(TNSCp_Hist->at(ssi_clone)));
		if(cp_clone == NULL)	{
			doslynxmessage("Unable to allocate memory for "
				"window.");
			OwnerClose();
			break;
		}
		TNSCp_visited->insert((void *)cp_clone);
	}
}
