//      This file extracted from the turbovision library in order to modify
//      the new operator.
//              03-03-94        Garrett Arch Blythe

/*------------------------------------------------------------*/
/* filename -       new.cpp                                   */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

#include<new.h>

#if !defined( __MEM_H )
#include <Mem.h>
#endif  // __MEM_H

#if !defined( __ALLOC_H )
#include <Alloc.h>
#endif  // __ALLOC_H

#if !defined( __STDLIB_H )
#include <StdLib.h>
#endif  // __STDLIB_H

#define Uses_TVMemMgr
#include <tv.h>

#include"tcapture.h"
#include"trace.h"
#include<dos.h>

TBufListEntry * near TBufListEntry::bufList = 0;

TBufListEntry::TBufListEntry( void*& o ) : owner( o )
{
    next = bufList;
    prev = 0;
    bufList = this;
    if( next != 0 )
	next->prev = this;
}

TBufListEntry::~TBufListEntry()
{
    owner = 0;
    if( prev == 0 )
	bufList = next;
    else
	prev->next = next;
    if( next != 0 )
	next->prev = prev;
}

void *TBufListEntry::operator new( size_t sz, size_t extra )
{
    return malloc( sz + extra*sizeof( unsigned ) );
}

void *TBufListEntry::operator new( size_t )
{
    return 0;
}

void TBufListEntry::operator delete( void *b )
{
    free( b );
}

Boolean TBufListEntry::freeHead()
{
    if( bufList == 0 )
	return False;
    else
	{
	delete bufList;
	return True;
	}
}

void * near TVMemMgr::safetyPool = 0;
size_t near TVMemMgr::safetyPoolSize = 0;
int near TVMemMgr::inited = 0;

TVMemMgr memMgr;

TVMemMgr::TVMemMgr()
{
    if( !inited )
	resizeSafetyPool();
};

void TVMemMgr::resizeSafetyPool( size_t sz )
{
    inited = 1;
    free( safetyPool );
    if( sz == 0 )
	safetyPool = 0;
    else
	safetyPool = malloc( sz );
    safetyPoolSize = sz;
}

int TVMemMgr::safetyPoolExhausted()
{
    return inited && (safetyPool == 0);
}

void TVMemMgr::allocateDiscardable( void *&adr, size_t sz )
{
    if( safetyPoolExhausted() )
	adr = 0;
    else
	{
	TBufListEntry *newEntry = new( sz ) TBufListEntry( adr );
	if( newEntry == 0 )
	    adr = 0;
	else
	    adr = (char *)newEntry + sizeof(TBufListEntry);
	}
}

void TVMemMgr::freeDiscardable( void *block )
{
    delete (TBufListEntry *)((char *)block - sizeof(TBufListEntry));
}



#if !defined( NDEBUG )
const BLK_SIZE = 16;
const BLK_DATA = 0xA6;
#else
const BLK_SIZE = 0;
#endif

void *operator new(size_t sz)   {
#ifndef RELEASE
	if(heapcheck() < 0)     {
		doslynxmessage("Heap corrupt.");
		sleep(5);
		exit(-1);
	}
#endif /* RELEASE */

	sz += BLK_SIZE;
	if(sz == 0)     {
		sz = 1;
	}

	//      Attempt to allocate the requested memory.
	void *temp = malloc(sz);

	//      Free off draw buffers first in further attempts.
	while(temp == 0 && TBufListEntry::freeHead() == True)   {
		temp = malloc( sz );
	}

	//      Still unsuccessful....
	if(temp == 0)   {
		//      If we've already gotten rid of the pool....
		if(TVMemMgr::safetyPoolExhausted())     {
			while(temp == 0)        {
				//      Free loaded HTexts third.
				_new_handler();
				temp = malloc(sz);
			}
		}
		else    {
			//      Free off safety pool second.
			TVMemMgr::resizeSafetyPool(0);
			temp = malloc(sz);
			if(temp == 0)   {
				while(temp == 0)        {
					//      Free loaded HTexts third and
					//      the really_safe_pool.
					_new_handler();
					temp = malloc(sz);
				}
			}
		}
	}

#if !defined( NDEBUG )
	memset(temp, BLK_DATA, BLK_SIZE);
#endif

	return((char *)temp + BLK_SIZE);
}


#if !defined( NDEBUG )
static void check( void *blk )
{
    for( int i = 0; i < BLK_SIZE; i++ ) {
	if(*((unsigned char *)blk + 1) != BLK_DATA)     {
		exit(-1);
	}
    }
}
#endif

void operator delete(void *blk) {

#ifndef RELEASE
	if(heapcheck() < 0)     {
		doslynxmessage("Heap corrupt.");
		sleep(5);
		exit(-1);
	}
#endif /* RELEASE */

	if(blk == 0)    {
		return;
	}
	void *tmp = (char *)blk - BLK_SIZE;

#if !defined( NDEBUG )
	check( tmp );
#endif

	free(tmp);

	//      Put before resizeing the really safe pool since TurboVision
	//      bases it's execution on the existance of the pool, if it
	//      doesn't exist, then we crash.
	if(TVMemMgr::safetyPoolExhausted())     {
		//      Attempt to reinstate the safety pool if used up.
		TVMemMgr::resizeSafetyPool();
		//      If didn't get it, don't let the really safe pool
		//      be built up either!
		if(TVMemMgr::safetyPoolExhausted())     {
			return;
		}
	}

	//      See if we need to try to fill back up our really safe pool.
	//      Refill backwards.
	if(really_safe_pool[Stop_Anchors] == NULL)      {
		for(register signed short int ssi_counter = RSP_NUM - 1;
			ssi_counter >= Stop_Anchors; ssi_counter--)     {

			if(really_safe_pool[ssi_counter] != NULL)       {
				continue;
			}

			really_safe_pool[ssi_counter] = (char *)malloc(
				RSP_SIZE);

			//      Break loop if unable.  No use
			//      in continuing.
			if(really_safe_pool[ssi_counter] == NULL)       {
				break;
			}
		}
	}
}
