//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	File:		globals.cpp
//	Purpose:	Contain global variables used in the DOSLYNX project.
//	Remarks/Portability/Dependencies/Restrictions:
//		The global variables used here are specific to the DOSLYNX
//		souce files, not the libraries used to supplement the project.
//	Revision History:
//		12-09-93	created
#include"globals.h"
#include"image.h"
#include<stddef.h>

// 	Increase default stack size from 0x1000k to ...
unsigned _stklen = 0x3000U;

//	Set the overlay buffer size to ....
//	Small size since will allow user to use EMS and XMS memory for overlay.
unsigned _ovrbuffer = 0x0C00U;

//	WWW stuff defining the application
char *HTAppName = "DosLynx";
char *HTAppVersion = "0.8a";

//	Ini path variable.
char *cp_inipath = NULL;

//	Temporary directory name to write temporary files.
char *cp_TempDir = NULL;

//	Tracing variable
#ifndef RELEASE
char c_trace = 0;
#endif // RELEASE

//	A collection of currently loaded HTexts.
TNSCollection *TNSCp_LoadedHTexts = NULL;

//	The maximum number of loaded HTexts.
unsigned short int usi_MaxLoadedHTexts = 10U;

//	Colors for HText drawing.
//	Not using palette, not profiecent in use or easy to do.
//	Will compensate for monochrome and black and white manually
//					            COLOR MONO  B&W
unsigned short int usia_TextColor[]		= { 0x1E, 0x07, 0x07 };
unsigned short int usia_AnchorColor[]		= { 0x1B, 0x07, 0x0F };
unsigned short int usia_SelectedColor[]		= { 0x7B, 0x70, 0x70 };
unsigned short int usia_SearchColor[]		= { 0x1C, 0x07, 0x0F };
unsigned short int usia_SearchSelectedColor[]	= { 0x7C, 0x70, 0x70 };

//	Global variable for C functions in CPP to communicate through.
TURLView *TURLV_current = NULL;

//	Global TCapture window
TCapture *TC = NULL;

//	Pointer to void *() function to hold old new handler.
void (*vfp_old_new_handler)();

//	Possible free window numbers.
Boolean B_freeWin[9] = {True, True, True, True, True, True, True, True, True};

//	Last search executed.
char ca_searchLast[usi_TILURLSize];

//	Graphics mode for displaying images.  NONE by default.
unsigned short int usi_graphicsmode = (image_modes)image_modes_total;

//	Default printer device.
char *cp_Printer = NULL;

//	Default home page or startup URL.
char *cp_Home = NULL;

//	HotList file name.
char *cp_HotList = NULL;

//	Error HTML file for DosLynx to display when unable to load a document.
char *cp_ErrorHTML = NULL;

//	Default reply to mail address for a user.
char *cp_ReplyTo = NULL;

//	Wether or not we allow any network access.
int i_networked = 1;

//	Default nntp server.
char *cp_nntphost = NULL;

//	EMS support.
Boolean B_ems = False;
unsigned short int usi_emspages = 0U;

//	XMS support.
Boolean B_xms = False;
unsigned long int uli_xmslength = 0UL;
unsigned long int uli_xmsstart = 0UL;

//	Really safe safety pool.
char *really_safe_pool[RSP_NUM];

//	Number of anchors actually skipped in document.
unsigned short int usi_skipped = 0U;

//	To keep anchor stuff in concordance when messing with stopping
//	their creation due to memory.
char c_DidStartAnchor = 0;

//	http, gopher, ftp, and wais proxy variables.
char *cp_http_proxy = NULL;
char *cp_gopher_proxy = NULL;
char *cp_wais_proxy = NULL;
char *cp_ftp_proxy = NULL;

//	Wether or not a proxy is being used.
BOOL B_proxy = FALSE;

//	Wether or not we show informational messages to help out our blind
//	users.
BOOL B_noInfo = FALSE;