//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TTempName
//	Include File:	ttempnam.h
//	Purpose:	Provide a class to handle the creation of temporary
//			file names.
//	Remarks/Portability/Dependencies/Restrictions:
//		Nothing but the file name is created.
//		Several TTempName objects created in a row may produce
//			duplicate file names.
//	Revision History:
//		02-15-94	created
#include"ttempnam.h"
#include"tcapture.h"
#include<stdio.h>

TTempName::TTempName(const char *cp_TemporaryDir)	{
//	Purpose:	Constructor.
//	Arguments:	cp_TemporaryDir	The directory in which to create the
//					temporary file.  If NULL, then the
//					current directory might be used.
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-15-94	created

	//	Create the temporary file name.
	cp_TempName = (const char *)::tempnam((char *)cp_TemporaryDir, "DLX");

	//	If unable to create, print a message.
	if(cp_TempName == NULL)	{
		doslynxmessage("No more temporary files available.");
	}
}