//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TPasswordInputLine
//	Include File:	tpasswor.h
//	Purpose:	Implement a password input line.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		04-22-94	created.
#include"tpasswor.h"
#include<string.h>

void TPasswordInputLine::draw()	{
//	Purpose:	Draw the input line without showing what was really
//			entered as the password.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Kludge to swap in and out password information before
//		drawing takes place.
//	Revision History:
//		04-22-94	created

	//	Save the current information.
	auto char *cp_savepass = newStr(data);

	//	Make current password all indecernable.
	auto char *cp_convert = data;
	while(*cp_convert != '\0')	{
		*cp_convert++ = '*';
	}

	//	Have base class draw.
	TInputLine::draw();

	//	Restore old password.
	strcpy(data, cp_savepass);
	delete(cp_savepass);
}