#ifndef __TTEMPNAME_H
//	Avoid include redundancy
#define __TTEMPNAME_H

//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Include File:	ttempnam.h
//	Purpose:	Provide class to handle creation of temporary file
//			names.
//	Remarks/Portability/Dependencies/Restrictions:
//		Does nothing but create the temporary name.
//		If several TTempName object are created in a row, their names
//		may be the same.
//	Revision History:
//		02-15-94	created

//	Constant defines

//	Required includes
#include<stddef.h>

//	Class declarations
class TTempName	{
	const char *cp_TempName;
public:
	TTempName(const char *cp_TemporaryDir = NULL);
	~TTempName();
	const char *getName() const;
	void unlink() const;
};

//	Global variable declarations

//	Macros

#endif // __TTEMPNAME_H
