//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#include"turlwind.h"
#include"urltodos.h"
#include"trace.h"
#include<string.h>

void TURLWindow::URLoader(const char *cp_URL, const char *cp_Index)	{
//	Purpose:	Load a URL in a standard manner.
//	Arguments:	cp_URL		the next url to load.
//			cp_Index	Will be NULL unless trying to load
//					and search request, say to a CSO
//					server.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Should be called whenever the window needs to load a url.
//		Will destroy an older URL view if it exists.
//	Revision History:
//		01-31-94	created
//		03-30-94	Will no longer notify the user in this
//				function if a document was unable to load.
//		04-07-94	Modified to load an error file on no loads.
//				Will definately hang if the user didn't
//				specify the errorhtml in the config file.

	//	Save the name, might get destroyed.
	//	Will not free this since will be in a collection.
	auto char *cp_load = newStr(cp_URL);

	//	If this is an index search.
	if(cp_Index != NULL)	{
		//	cut out any searching done in this older url.
		auto char *cp_nosearch = strchr(cp_load, '?');
		if(cp_nosearch != NULL)	{
			*cp_nosearch = '\0';
			cp_nosearch = newStr(cp_load);
			delete(cp_load);
			cp_load = cp_nosearch;
		}
	}

	//	First the message.
	doslynxmessage("Loading " << cp_load << (cp_Index == NULL ? "" : "?")
		<< (cp_Index == NULL ? "" : cp_Index));

	//	Disable the search command until something enables it.
	disableCommand(cmSearchIndex);

	//	Get the window size and adjust for a view.
	TRect TR = getExtent();
	TR.grow(-1, -1);

	//	If we have a current view, save pointer to get rid of it.
	auto TURLView *TURLVp_old = TURLV;

	//	Create the view.
	TURLV = new TURLView(TR, standardScrollBar(
		sbHorizontal | sbHandleKeyboard), standardScrollBar(
		sbVertical | sbHandleKeyboard), cp_load, cp_Index);

	//	If the creation is valid.
	if(TURLV != NULL && TURLV->valid(cmValid) == True)	{
		//	If not the same document, change title here.
		if(title != NULL)
			delete((void *)title);
		title = newStr(TURLV->getTitle());

		//	If there isn't a title, provide one.
		if(title == NULL)	{
			title = newStr("Untitled");
		}

		//	Insert the new url title in our visited stack.
		//	Be sure and check to see if it was a search.
#ifndef RELEASE
		trace("inserting loaded document into window history.");
#endif // RELEASE
		if(cp_Index == NULL)	{
			TNSCp_visited->insert((void *)cp_load);
		}
		else	{
			//	Remove any other search strings before.
			auto char *cp_delsearch = strchr(cp_load, '?');
			if(cp_delsearch != NULL)	{
				*cp_delsearch = '\0';
			}
			//	Create the string to insert.
			auto char *cp_loadandsearch = new char[strlen(cp_load)
				+ strlen(cp_Index) + 2];
			//	Copy over the information.
			strcpy(cp_loadandsearch, cp_load);
			strcat(cp_loadandsearch, "?");
			strcat(cp_loadandsearch, cp_Index);
			//	Remove the old name.
			delete(cp_load);
			//	Insert it.
			TNSCp_visited->insert((void *)cp_loadandsearch);
		}

		//	Remove the old view from the window now.
#ifndef RELEASE
		trace("swapping views.");
#endif // RELEASE
		if(TURLVp_old != NULL)	{
			remove(TURLVp_old);
			destroy(TURLVp_old);
		}

		//	Insert the view in the window and bring this window
		//	to the front.
		insert(TURLV);
		makeFirst();

		//	See if the the new view is an index.  If so, set
		//	so that we will know in the future.
		if(TURLV->isIndex() == True)	{
			IndexInit();
		}
		else	{
			//	Otherwise set the index to false.
			B_isIndex = False;
			disableCommand(cmSearchIndex);
		}
	}
	else	{
		//	Do not insert the attempted URL in the window's
		//	history.
		delete(cp_load);

		//	Here's the catch.  On a file download we will get to
		//	this code anyhow.  Check for it.  If so, we only want
		//	to put back up the old view.
		if(TURLV != NULL && TURLV->isDownload() == True)	{
#ifndef RELEASE
			trace("download detected.");
#endif // RELEASE
			//	Bring us up to the front.
			makeFirst();

			//	Destroy the view that downloaded.
#ifndef RELEASE
			trace("attempting to destory downloading view.");
#endif // RELEASE
			destroy(TURLV);

			//	Reinstate the old view.
			TURLV = TURLVp_old;

			//	Worst case scenario, there is no view....
			//	Attempt to close the window.
			if(TURLV == NULL)	{
				OwnerClose();
			}
			return;
		}
#ifndef RELEASE
		trace("attempting to destroy failed load.");
#endif // RELEASE
		//	If a view was actually created, get rid of it.
		if(TURLV != NULL)	{
			destroy(TURLV);
		}
		TURLV = TURLVp_old;

		//	Load up our Error HTML file.
		//	First convert to a URL, then call recusively.
#ifndef RELEASE
		trace("loading error html local file.");
#endif // RELEASE
		auto char *cp_Errorfile = new char[strlen(::cp_ErrorHTML) +
			(cp_inipath != NULL) ? strlen(::cp_inipath) : 0 + 2];
		if(cp_inipath != NULL)	{
			strcpy(cp_Errorfile, cp_inipath);
			strcat(cp_Errorfile, "\\");
		}
		else	{
			*cp_Errorfile = '\0';
		}
		strcat(cp_Errorfile, cp_ErrorHTML);
		auto char ca_errorURL[usi_TILURLSize];
		dostourl(ca_errorURL, cp_Errorfile);
		delete(cp_Errorfile);

		//	Recursive call will destroy the current view if one
		//	exists.
		URLoader(ca_errorURL);
	}
}