//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx : public TApplication
//	Include File:	TDosLynx.h
//	Purpose:	Implement our application object.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-09-93	created
//		02-09-94	Split all members into seperate files to
//				enhance overlay support.
#define Uses_TDeskTop
#include"tdoslynx.h"
#include"globals.h"
#include<new.h>
#include<dos.h>

TDosLynx::TDosLynx(int i_argc, char **cpp_argv)
	: TProgInit(&TDosLynx::initStatusLine, &TDosLynx::initMenuBar,
		&TDosLynx::initDeskTop)	{
//	Purpose:	Constructor
//	Arguments:	i_argc		Number of command line arguments passed
//					in by main.
//			cpp_argv	The command line arguments.
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//		Uses the global variable TC.
//	Revision History:
//		12-09-93	created
//		02-25-94	Added advanced memory handling to the
//				application to avoid often crashes.

	//	There is at this point no view to be removed.
	TVp_ToBeRemoved = NULL;

	//	There is also no image to be displayed.
	cp_ToBeViewed = NULL;

	//	We initially always start in low video.
	B_isLow = True;

	//	We want to load the home page by default.
	B_loadHome = True;

	//	The default printing device.
	::cp_Printer = newStr("NUL");

	//	The default error file.
	::cp_ErrorHTML = newStr("ERROR.HTM");

	//	The default nntp server.
	::cp_nntphost = newStr("news");

	//	Create the captured view of stdout and stderr.
	TRect TR_extent;
	TR_extent = deskTop->getExtent();
	TR_extent.a.y = TR_extent.b.y - 6;
	::TC = new TCapture(TR_extent, "Messages", 4096);
	deskTop->insert(::TC);

	//	Create a clock view in the upper right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 9;
	TR_extent.b.y = TR_extent.a.y + 1;
	TCV_clock = (TClockView *)validView(new TClockView(TR_extent));
	insert(TCV_clock);

	//	Create a heap view in the lower right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 13;
	TR_extent.a.y = TR_extent.b.y - 1;
	THV_heap = (THeapView *)validView(new THeapView(TR_extent));
	insert(THV_heap);

	//	Create a disk view in the lower right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 26;
	TR_extent.b.x -= 13;
	TR_extent.a.y = TR_extent.b.y - 1;
	TDV_disk = (TDiskView *)validView(new TDiskView(TR_extent));
	insert(TDV_disk);

	//	Create socket activity in the lower right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 39;
	TR_extent.b.x -= 26;
	TR_extent.a.y = TR_extent.b.y - 1;
	TSV_sock = (TSockView *)validView(new TSockView(TR_extent));
	insert(TSV_sock);

	//	Create the HText collection.
	::TNSCp_LoadedHTexts = new TNSCollection(5, 5);

	//	Initialize the new memory failsafe.
	vfp_old_new_handler = set_new_handler(&::ReleaseSomeMemory);

	//	Search for the /p command line option and do it if it exists
	//	The /p defines where the configuration file is located.
	for(int i_counter = 0; i_counter < i_argc; i_counter++)	{
		if(*(cpp_argv[i_counter]) == '/')	{
			if(toupper(*(cpp_argv[i_counter] + 1)) == 'P')	{
				EvalOption(i_counter, cpp_argv[i_counter]);
			}
		}
	}

	//	Send the configuration file to be examined.
	EvalConfigFile();

	//	See if we should set up expanded and then extended overlays.
	if(::B_ems == True)	{
		if(::_OvrInitEms(0U, 0U, ::usi_emspages) != 0)	{
			doslynxmessage("Unable to initialize EMS.");
		}
	}
	if(::B_xms == True)	{
		if(::_OvrInitExt(::uli_xmsstart, ::uli_xmslength) != 0)	{
			doslynxmessage("Unable to initialize XMS.");
		}
	}

	//	Send all command line options to be evaluated.
	for(i_counter = 0; i_counter < i_argc; i_counter++)
		EvalOption(i_counter, cpp_argv[i_counter]);

	//	See if we should load up the home page.
	if(B_loadHome == True && ::cp_Home != NULL)	{
		OpenURL(cp_Home);
	}
}