//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TCapture
//	Include File:	tcapture.h
//	Purpose:	Captures c streams stdout and sterr to a window.
//	Remarks/Portability/Dependencies/Restrictions:
//		Works in conjuction with the c source file capstdio.c and
//		two global variables capstdout and capstderr in globals.c
//	Revision History:
//		01-08-94	created
//		02-09-94	Split all members into seperate files.
#include"tcapture.h"

void TCapture::handleEvent(TEvent& TE)	{
//	Purpose:	Event handler for the TCapture window.
//	Arguments:	TE	The event.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-08-94	created

	//	Do our handling of the event.
	if(TE.what & evCommand)	{
		switch(TE.message.command)	{
		case cmClose:
			//	Don't want to close window, only hide.
			hide();
			clearEvent(TE);
			break;
		}
	}

	//	Call the base event handler.
	TWindow::handleEvent(TE);
}
