/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   Version 0.8
   Fri Feb  1 1991

   jonathan@Think.COM

*/

#ifndef _H_SOURCE
#define _H_SOURCE

#include "SourceID.h"

typedef struct source{
  char *name;
  char *directory;
  char server[STRINGSIZE];
  char service[STRINGSIZE];
  char database[STRINGSIZE];
  char cost[STRINGSIZE];
  char units[STRINGSIZE];
  char *description;
  FILE *connection;
  long buffer_length;
  boolean initp;
  char *maintainer;
} _Source, *Source;

typedef struct sourcelist {
  SourceID thisSource;
  struct sourcelist *nextSource;
} _SourceList, *SourceList;

typedef struct slist {
  Source thisSource;
  struct slist *nextSource;
} _SList, *SList;

/* functions */

SourceList ReadListOfSources();
SourceList makeSourceList();
SList makeSList();
char **buildSourceItemList();
extern void ReadSourceDirectory();
void format_source_cost();

#endif
