;; ls6-autoloads.el --
;; Author          : Ulrich Pfeifer
;; Created On      : Wed Mar 24 13:57:53 1993
;; Last Modified By: Ulrich Pfeifer
;; Last Modified On: Fri Mar 26 11:37:47 1993
;; Update Count    : 11
;; Status          : Unknown, Use with caution!
;; $Locker: pfeifer $
;; $Log: ls6-autoloads.hdr,v $

(defvar local-emacs
  (not (or (string-match "Lucid" (emacs-version))
           (string-match '"18.58.10" (emacs-version))))
  "Variable indicates if the local emacs (version 18.58 is used)")

(defun smember (elt lst)
  (cond ((null lst) nil)      
        ((null elt) nil)      
        ((string= (car lst) elt) elt) 
        (t (smember elt (cdr lst))))) 

(defvar package-list nil "alist of ls6 elisp packages")

(if (featurep 'ls6-autoloads)
    (set-variable 'package-list nil))

(provide 'ls6-autoloads)


(defun read-package-name (&optional initial-input)
  (completing-read "Package: "
                   package-list
                   nil                  ; predicate
                   t                    ; require match
                   initial-input))
   
(defun load-package (&optional package)
  "Force loading of PACKAGE"
  (interactive)
  (if package ()
    (setq package (read-package-name)))
  (if package 
      (progn
        (message "Loading Package %s ... " package)
        (let* ((entry (assoc package package-list))
               (loadf (if entry (car (cdr entry)))))
          (if loadf (eval loadf)
            (progn
              (message "Package %s has no load function" package)
              (ding))))
        (message "Loading Package %s ... done" package))
    (progn
      (message "Package %s  not found" package)
      (ding))))

(defun help-package (&optional package)
  "Give help on PACKAGE"
  (interactive)
  (if package ()
    (setq package (read-package-name)))
  (if package 
      (progn
        (message "Searching for Package %s ... " package)
        (let* ((entry (assoc package package-list))
               (helps (if entry (cdr (cdr entry)))))
          (if helps
              (progn
                (with-output-to-temp-buffer "*Help*")
                (insert "Help for package " package)
                (center-line)
                (insert "\n\n" helps))
            (progn
              (message "Package %s has no help info" package)
              (ding))))
        (message "Searching for Package %s ... done" package))
    (progn
      (message "Package %s  not found" package)
      (ding))))

;;
;; PACKAGE: ange-ftp 4.20               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/ange-ftp.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
;; no autoload: use it or not

;; add to package-list
(setq package-list 
      (cons 
       (cons "ange-ftp" 
             (cons
              '(
                (require 'ange-ftp)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: art-yow 10/91               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/art-yow.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'yow "art-yow" "" t)
(autoload 'reset-yow-file "art-yow" "" t)
(autoload 'insert-n-line-yow "art-yow" "" t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "art-yow" 
             (cons
              '(
                (require 'art-yow)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: auc-tex 5.4            
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/auc-tex-5.4/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
;; *.tex -> latex-mode
(setq auto-mode-alist (cons (cons "\\.tex$"  'LaTeX-mode) auto-mode-alist))
(autoload 'tex-mode "auc-tex" "Automatic select TeX or LaTeX mode" t)
(autoload 'plain-tex-mode "auc-tex" "Mode for Plain TeX" t)
(autoload 'latex-mode "auc-tex" "Mode for LaTeX" t)
(setq LaTeX-outline-regexp "\\\\\\(appendix\\|documentstyle\\|part\\|chapt\\|sectio\\|subsect\\|subsubs\\|paragraph\\|subparagraph\\)")
(defun Ctl-C-prefix ()		; Use Ctl-C as a command prefix
  Ctl-C-keymap)
(setq Ctl-C-keymap (make-keymap))	; allocate Ctl-C keymap table
(global-set-key "\C-c" (Ctl-C-prefix)) ; define Ctl-C function
(define-key Ctl-C-keymap "m" 'LaTeX-math-mode)
(autoload 'LaTeX-math-mode "tex-math" t)
;;
;;  Setup outline-minor-mode
;; 
(define-key Ctl-C-keymap "o" 'outline-minor-mode) 
(autoload 'outline-minor-mode "outline-m" t)
(make-variable-buffer-local 'outline-prefix-char)
(setq-default outline-prefix-char "\C-l")
(make-variable-buffer-local 'outline-regexp)
(setq-default outline-regexp "[*\^l]+")
(make-variable-buffer-local 'outline-level-function)
(setq-default outline-level-function 'outline-level-default)
;;
;; Personal defaults for AUC-TeX mode
;;
(setq LaTeX-figure-label "fig:")
(setq LaTeX-table-label "tab:")
(setq LaTeX-section-label "sec:")
(setq LaTeX-default-style-options "din_a4,12pt,german")
(setq LaTeX-float "hbtp")
(make-variable-buffer-local 'outline-prefix-char)
(setq-default outline-prefix-char "\C-l")
(make-variable-buffer-local 'outline-regexp)
(setq-default outline-regexp "[*\^l]+")
(make-variable-buffer-local 'outline-level-function)
(setq-default outline-level-function 'outline-level-default)

;; add to package-list
(setq package-list 
      (cons 
       (cons "auc-tex" 
             (cons
              '(
                
                )
              "TeXen"
              )
             ) 
       package-list))



;;
;; PACKAGE: auto-gc Mon, 15 Mar 93               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/auto-gc.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'auto-gc "auto-gc" "Garbage collect when user isn't looking. " t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "auto-gc" 
             (cons
              '(
                (require 'auto-gc)
(auto-gc 1)
                )
              "automatically garbage collect in the background when
user is apparently resting.  Prevents emacs from
sitting idle for hours, and then, just as you press
the first key, saying \"garbage collecting...\"."
              )
             ) 
       package-list))



;;
;; PACKAGE: bal-wins 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bal-wins.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'balance-windows "bal-wins" 
          "Makes all visible windows the same size." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "bal-wins" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: bbdb 1.47; 11-sep-92.
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bbdb-1.47/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar mail-setup-hook nil)
(setq mail-setup-hook (cons 'bbdb-insinuate-sendmail mail-setup-hook))
(defvar rmail-add-re t "if T add \"Re: \" to subject")
(autoload 'bbdb         "bbdb-com" "Insidious Big Brother Database" t)
(autoload 'bbdb-name    "bbdb-com" "Insidious Big Brother Database" t)
(autoload 'bbdb-company "bbdb-com" "Insidious Big Brother Database" t)
(autoload 'bbdb-net     "bbdb-com" "Insidious Big Brother Database" t)
(autoload 'bbdb-notes   "bbdb-com" "Insidious Big Brother Database" t)
(defvar rmail-mode-hook '())
(setq rmail-mode-hook 
      (cons '(lambda () (require 'bbdb-rmail)) 
            rmail-mode-hook))
(setq gnus-Startup-hook '(lambda () (require 'bbdb-gnus)
                           (bbdb-insinuate-gnus)))
;(setq mh-folder-mode-hook '(lambda () (require 'bbdb-mhe)))
(defvar vm-mode-hooks nil)
(setq vm-mode-hooks (cons '(lambda () (require 'bbdb-vm))
                          vm-mode-hooks))
(set-variable 'bbdb-north-american-phone-numbers-p nil)
(set-variable 'bbdb-use-pop-up nil)

;; add to package-list
(setq package-list 
      (cons 
       (cons "bbdb" 
             (cons
              '(
                (require 'bbdb-com)		; load it anyway
(require 'bbdb-canonicalize)
                )
              "Email/Address Database"
              )
             ) 
       package-list))



;;
;; PACKAGE: bbdb-adr 1.17
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bbdb/bbdb-adr.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'bbdb-tex     "bbdb-adr" "Insidious Big Brother Database" t)


;; add to package-list
(setq package-list 
      (cons 
       (cons "bbdb-adr" 
             (cons
              '(
                (require 'bbdb-adr)		; load it anyway

                )
              "This package allows the the generation of TeX source for an address
list from an Insidious Big Brother Database."
              )
             ) 
       package-list))



;;
;; PACKAGE: bbdb-canonicalize 1.2
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bbdb/bbdb-canonicalize.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar bbdb-load-hook nil)
(setq bbdb-load-hook
   (cons
      '(lambda () (require 'bbdb-canonicalize))
       bbdb-load-hook))


;; add to package-list
(setq package-list 
      (cons 
       (cons "bbdb-canonicalize" 
             (cons
              '(
                (require 'bbdb-canonicalize)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: bbdb-letter 1.5           
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bbdb/bbdb-letter.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'bbdb-letter "bbdb-letter" nil t)
(autoload 'bbdb-private-letter "bbdb-letter" nil t)
(defvar bbdb-mode-map (make-keymap))
(define-key bbdb-mode-map "l" 'bbdb-letter)
(define-key bbdb-mode-map "L" 'bbdb-private-letter)


;; add to package-list
(setq package-list 
      (cons 
       (cons "bbdb-letter" 
             (cons
              '(
                (require 'bbdb-letter)		; load it anyway

                )
              "BBDB-based Letter Generator for GNU Emacs"
              )
             ) 
       package-list))



;;
;; PACKAGE: bug-report 1.4               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/bug-report.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'bug-report "bug-report" "Report Emacs Bugs" t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "bug-report" 
             (cons
              '(
                
                )
              "Report Emacs Bugs"
              )
             ) 
       package-list))



;;
;; PACKAGE: c++-mode 2.40              
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/c++-mode.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq auto-mode-alist (cons (cons "\\.cc$"  'c++-mode) auto-mode-alist))
(setq auto-mode-alist (cons (cons "\\.hh$"  'c++-mode) auto-mode-alist))
(autoload 'c++-mode "c++-mode" "Major mode for editing C++ code" t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "c++-mode" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: c-mode                
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(modify-syntax-entry ?_ "w" c-mode-syntax-table)

;; add to package-list
(setq package-list 
      (cons 
       (cons "c-mode" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: c-style 2.1             
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/c-style.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'set-c-style "c-style" nil t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "c-style" 
             (cons
              '(
                
                )
              "sets c-style control variables"
              )
             ) 
       package-list))



;;
;; PACKAGE: csh-mode 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/csh-mode.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload  'csh-mode "csh-mode" "Major mode for editing csh scripts." t)


;; add to package-list
(setq package-list 
      (cons 
       (cons "csh-mode" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: cweb-mode   July 1990             
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'cweb-mode "cweb" "Major mode like TeX mode" t)
(setq auto-mode-alist
            (append '(("\\.web$" . cweb-mode)) auto-mode-alist))

;; add to package-list
(setq package-list 
      (cons 
       (cons "cweb-mode" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: dired-adds 1 Feb 90 22:35:33 GMT               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/dired-adds.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq dired-mode-hook '(my-dired-mode-hook))
(autoload 'my-dired-mode-hook "dired-adds"
		"Add new features to dired." t) 


;; add to package-list
(setq package-list 
      (cons 
       (cons "dired-adds" 
             (cons
              '(
                
                )
              "Sorting in dired-mode"
              )
             ) 
       package-list))



;;
;; PACKAGE: EDB 1.11           
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/edb-1.11/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'database "database" "EDB database package" t nil)
(autoload 'db-find-file "database" "EDB database package" t nil)
(setq find-file-hooks (cons 'after-find-file-edb find-file-hooks))
(defun after-find-file-edb ()
  "If this is a database file in EDB internal file format, run EDB."
  ;; When this is called, we are at the beginning of the buffer.
  (if (looking-at ";; Database file written by EDB")
      (progn
        (require 'database)
        (db-this-buffer))))

;; add to package-list
(setq package-list 
      (cons 
       (cons "EDB" 
             (cons
              '(
                (load-library "database")
                )
              "Database"
              )
             ) 
       package-list))



;;
;; PACKAGE: emerge 5 beta               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/emerge.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'emerge-files                  "emerge" nil t nil)
(autoload 'emerge-files-with-ancestor    "emerge" nil t nil)
(autoload 'emerge-buffers		 "emerge" nil t nil)
(autoload 'emerge-buffers-with-ancestor  "emerge" nil t nil)

;; add to package-list
(setq package-list 
      (cons 
       (cons "emerge" 
             (cons
              '(
                
                )
              "Merge Versions of Files interactively"
              )
             ) 
       package-list))



;;
;; PACKAGE: env 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/env.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'modify-environment "env" "Modify environment variable" t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "env" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: find-dired 10/05/91               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/find-dired.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'find-dired "find-dired"
          "Run `find' and go into dired-mode on a buffer of the output.
The command run is \"find . \( ARGS \) -ls\" (after changing into DIR)." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "find-dired" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: fnexpand ?              
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/fnexpand.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "fnexpand" 
             (cons
              '(
                (require 'fnexpand)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: gnus 3.14.1               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/gnus-3.14.1/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq gnus-local-domain "ls6.informatik.uni-dortmund.de")
(setq gnus-local-organization 
      "Universitaet Dortmund, Lehrstuhl Informatik VI")
(setq  gnus-nntp-server "fbi-news")
(autoload 'gnus "gnus" "Read network news." t)
(autoload 'gnus-post-news "gnuspost" "Post a news." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "gnus" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: header  2-Dec-1991              
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/header.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(require 'header)
;; csh-mode
(defvar csh-mode-hook nil)
(setq csh-mode-hook 
      (cons 
       '(lambda nil
         (make-local-variable 'make-header-hooks)
         (setq make-header-hooks (cons 'header-shell 
                                       (default-value 'make-header-hooks))))
       csh-mode-hook))
;; sh-mode
(defvar sh-mode-hook nil)
(setq sh-mode-hook 
      (cons 
       '(lambda nil
         (make-local-variable 'make-header-hooks)
         (make-variable-buffer-local 'explicit-shell-file-name)
         (set-variable 'explicit-shell-file-name "/bin/sh")
         (setq make-header-hooks (cons 'header-shell 
                                       (default-value 'make-header-hooks)))  )
       sh-mode-hook))


;; add to package-list
(setq package-list 
      (cons 
       (cons "header" 
             (cons
              '(
                (require 'header)
                )
              "Support for creation and automatic update of file headers"
              )
             ) 
       package-list))



;;
;; PACKAGE: hippie-expand                
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/hippie-expand.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'hippie-expand "hippie-expand" "Try to expand text before point")
(global-set-key "\M-/" 'hippie-expand)

;; add to package-list
(setq package-list 
      (cons 
       (cons "hippie-expand" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: hscroll 1992               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/hscroll.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'hscroll-mode "hscroll" 
              "Toggle HScroll mode in the current buffer.
With arg, turn HScroll mode on if arg is positive, off otherwise.
In HScroll mode, truncated lines will automatically scroll left or right
when point gets near either edge of the window." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "hscroll" 
             (cons
              '(
                
                )
              "Minor mode to automatically scroll truncated lines horizontally"
              )
             ) 
       package-list))



;;
;; PACKAGE: HyperActiveFTP rs 22 Apr 92               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/HyperActive/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "HyperActiveFTP" 
             (cons
              '(
                (load-file "/usr/local/ls6/emacs-18.58/lisp-ls6/HyperActive/active-hyper.requirements.el")
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: Hyperbole 3.06               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/hyperbole-3.0/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(load "hyperbole")

;; add to package-list
(setq package-list 
      (cons 
       (cons "Hyperbole" 
             (cons
              '(
                (load "hsite")
                )
              "Hyperbole hypertext system"
              )
             ) 
       package-list))



;;
;; PACKAGE: iso 1.7               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/iso.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'ISO-text-mode "iso" "ISO Text Mode" t)
(autoload 'electric-accents "el-accents" "Typewriter dead keys" t)
(setq ISO-capable t)              ; if you can

;; add to package-list
(setq package-list 
      (cons 
       (cons "iso" 
             (cons
              '(
                
                )
              "(ISO-text-mode off)	to switch ISO text mode
(ISO--build-ext-map)	creates and fills ISO-key-map
(ISO--augment-syntax-table) Augments syntax table for IO characters."
              )
             ) 
       package-list))



;;
;; PACKAGE: ISO-TeX  Tue Aug 25 20:16:51 1992              
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/ISO-tex.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'TeX-to-ISO "ISO-tex" "no comment here" t)
(autoload 'ISO-to-TeX "ISO-tex" "no comment here" t)


;; add to package-list
(setq package-list 
      (cons 
       (cons "ISO-TeX" 
             (cons
              '(
                
                )
              "ISO chars in latex-mode"
              )
             ) 
       package-list))



;;
;; PACKAGE: ispell 2.19               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/ispell.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'ispell-word "ispell"
  	"Check the spelling of word in buffer." t)
(autoload 'ispell-region "ispell"
  	"Check the spelling of region." t)
(autoload 'ispell-buffer "ispell"
		"Check the spelling of buffer." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "ispell" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: j-shell 1.4               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-18.58/j-shell")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "j-shell" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: kill-buffers 1.1               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/kill-buffers.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'kill-readonly-buffers   "kill-buffers" nil t)
(autoload 'kill-unmodified-buffers "kill-buffers" nil t)
(autoload 'kill-tmp-buffers        "kill-buffers" nil t)


;; add to package-list
(setq package-list 
      (cons 
       (cons "kill-buffers" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: latex-adds 1.2               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/latex-adds.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar LaTeX-mode-map (make-keymap))
(define-key LaTeX-mode-map "\C-ck" 'LaTeX-clean-simple)
(define-key LaTeX-mode-map "\C-ct" 'LaTeX-insert-today)
(autoload 'LaTeX-clean-simple "latex-adds" nil t)
(autoload 'LaTeX-insert-today "latex-adds" 
  "Return a string representing todays date according to flavor." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "latex-adds" 
             (cons
              '(
                (require 'latex-adds)
                )
              "utilities for latex-mode"
              )
             ) 
       package-list))



;;
;; PACKAGE: lib-complete 1.7               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/lib-complete.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "lib-complete" 
             (cons
              '(
                (load-library '"lib-complete")
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: lispdir 4               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/lispdir.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'lisp-dir-apropos "lispdir" 
"Display entries in Lisp Code Directory for TOPIC in separate
window.  Calls value of lisp-dir-apropos-hook with no args if that
value is non-nil." t)
(defvar lisp-code-directory
 (concat (getenv "LEMACSHOME") '"/lisp-ls6/LCD-datafile")
      "*Database of free lisp code.  Entries are in the form:
Name|Author|Contact|Description|Date|Version|Archive")

;; add to package-list
(setq package-list 
      (cons 
       (cons "lispdir" 
             (cons
              '(
                
                )
              "Lisp Code Directory formatter and apropos"
              )
             ) 
       package-list))



;;
;; PACKAGE: lwf May 2, 1989               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "lwf" 
             (cons
              '(
                (setq lpr-command "lpr")
(setq lpr-switches '("-Pqms" "-nn" "-p"))
(autoload 'zprint-buffer "lwf" "print buffer on Laserwriter" t)
(autoload 'zprint-region "lwf" "print region on Laserwriter" t)

                )
              "print buffers and regions"
              )
             ) 
       package-list))



;;
;; PACKAGE: mail Dist 18.58               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "mail" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: makefile-adds 1.2                
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/makefile-adds.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'Makefile-center-assignment "makefile-adds" nil t nil)
(autoload 'Imakefile-rule-add-eoln    "makefile-adds" nil t nil)

;; add to package-list
(setq package-list 
      (cons 
       (cons "makefile-adds" 
             (cons
              '(
                (require 'makefile-adds)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: math 89/05/24       
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/math/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq auto-mode-alist (append
                       (list
                        (cons "\\.m$" 'math-mode) ; packages
                        (cons "\\.nb$" 'math-mode) ; mac notebooks
                        (cons "\\.nbl$" 'math-mode)) ; math-mode notebooks
                       auto-mode-alist))
;;
(autoload 'math "math-mode" "Create a new math-mode buffer." t)
(autoload 'math-mode "math-mode" "Start up math-mode for a file.")
(setq math-eval-init-cells nil)

;; add to package-list
(setq package-list 
      (cons 
       (cons "math" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: minibuf 12/13/89
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/minibuf.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "minibuf" 
             (cons
              '(
                (load-library "minibuf")
                )
              "Resize minibuffer"
              )
             ) 
       package-list))



;;
;; PACKAGE: MISC *-*               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "MISC" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: multishell 91-07-22               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/multi-shell.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "multishell" 
             (cons
              '(
                (require 'multishell)
                )
              "multiple running shells in one emacs session?"
              )
             ) 
       package-list))



;;
;; PACKAGE: myisearch 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/myisearch.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "myisearch" 
             (cons
              '(
                (fmakunbound 'isearch)
(autoload 'isearch "myisearch") 
                )
              "isearch across linie boundaries"
              )
             ) 
       package-list))



;;
;; PACKAGE: par-align 28-Apr-89      
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/par-align.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "par-align" 
             (cons
              '(
                (require 'par-align)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: proto 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/show-proto.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "proto" 
             (cons
              '(
                (load-library "show-proto")
(setq proto-database "/usr/local/ls6/emacs-18.58/lisp-ls6/proto-database")
(x-mouse-define-key "x-mouse-cm2-window-click"  ; or whatever button 
                          t 'default 'show-function-prototypes)
(define-key  global-map  "\C-c\C-p"  'show-function-prototypes)
                )
              "A function which will display a one line prototype of a C function in
the minibuffer area.  As writen it is designed for use with the
x-sb-mouse package by Sullivan Beck.  However it can easily be adapted
for keyboard-only use by removing the two lines as commented in the code.
It will then use the word the point is currently in when it is called."
              )
             ) 
       package-list))



;;
;; PACKAGE: rcs Revision: 1.67               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/rcs.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "rcs" 
             (cons
              '(
                (load "rcs")
(load "add-log")
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: rmail Dist 18.58               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'rmail-mode "rmail" nil t)
(setq rmail-ignored-headers 
      (concat rmail-ignored-headers
              "\\|^X-Face:\\|^X-Planation:"))
;;

;; add to package-list
(setq package-list 
      (cons 
       (cons "rmail" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: roget 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/roget/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'thesaurus-lookup-word "thesaurus"
   "Look up the word WORD in the thesaurus" t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "roget" 
             (cons
              '(
                
                )
              "Query the Roget Thesaurus"
              )
             ) 
       package-list))



;;
;; PACKAGE: saveconf Norma Jean               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/saveconf.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "saveconf" 
             (cons
              '(
                (require 'saveconf)
                )
              "This package of functions gives Emacs the ability to remember which
files were being visited, the windows that were on them, and the
value of point in their buffers the last Emacs session in the same
directory.  This is an emulation of an old Gosling Emacs feature.
"
              )
             ) 
       package-list))



;;
;; PACKAGE: sccs v2.0 March 4 1990
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/sccs.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'sccs "sccs" "Emacs sccs interface" t )

;; add to package-list
(setq package-list 
      (cons 
       (cons "sccs" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: server Dist 18.58               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "server" 
             (cons
              '(
                (load-library "server")
(setq server-program "/usr/local/ls6/emacs-18.58/etc/server")
(server-start)
                )
              "connections to emacsclient"
              )
             ) 
       package-list))



;;
;; PACKAGE: sh-mode 
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/sh-mode.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload  'sh-mode "sh-mode" "Major mode for editing sh scripts." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "sh-mode" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: shadow-files 1.2               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/shadow-files.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
;; no autoload: use it or not

;; add to package-list
(setq package-list 
      (cons 
       (cons "shadow-files" 
             (cons
              '(
                (require 'shadow-files)
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: shell Dist 18.58               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "shell" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: steve 1.18           
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/steve-mode.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(set-variable 'completion-ignored-extensions 
  	    (append '( ".stv" ".stw" ) completion-ignored-extensions))
(autoload 'steve-mode "steve-mode"
  	"Major Mod for editing converted STEVE files." t)
(setq auto-mode-alist (cons (cons "\\.ste$"  'steve-mode) auto-mode-alist))

;; add to package-list
(setq package-list 
      (cons 
       (cons "steve" 
             (cons
              '(
                
                )
              "Editing Steve-Files"
              )
             ) 
       package-list))



;;
;; PACKAGE: supercite 2.3               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/sc-2.3/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq mail-yank-hooks 'sc-cite-original)
(autoload 'sc-cite-original "sc" "Supercite 2.2" t)
(defun my-sc-overload-hook ()
  (require 'sc-oloads)     ; be sure this file is on your load-path
  (sc-overload-functions)
  )
(defvar mail-setup-hook nil)
(setq mail-setup-hook  
      (cons 'my-sc-overload-hook mail-setup-hook)) ; for RMAIL,PCMAIL,GNUS


;; add to package-list
(setq package-list 
      (cons 
       (cons "supercite" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: text-mode -*-               
;;

;; set load-path
(let ((dir (file-name-directory 
            "")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads

(defvar text-mode-hook nil)
(setq text-mode-hook 
      (cons 'turn-on-auto-fill text-mode-hook))



;; add to package-list
(setq package-list 
      (cons 
       (cons "text-mode" 
             (cons
              '(
                
                )
              "Defaults for text-mode"
              )
             ) 
       package-list))



;;
;; PACKAGE: trash 1.1
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/trash.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'find-trash "trash" 
  "run find-dired to find trash in the file system" t nil)

;; add to package-list
(setq package-list 
      (cons 
       (cons "trash" 
             (cons
              '(
                
                )
              "find trash via find-dired"
              )
             ) 
       package-list))



;;
;; PACKAGE: uncompress Dist 18.58               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-18.58/uncompress.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "uncompress" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: util 1.5               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/util.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "util" 
             (cons
              '(
                (load-library '"util")
                )
              "Utilities
join-two-lines
prefix-region
include-original-mail
my-add-change-log-entry
this-line-to-top-of-screen
upcase-char
my-next-line
LaTeX-german
set-TeX-directory-to-current
LaTeX-outline"
              )
             ) 
       package-list))



;;
;; PACKAGE: vcs 1.15 19-Sep-1992               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/vcs/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "vcs" 
             (cons
              '(
                (load-library "vcs-init")
                )
              "Vcs is an emacs interface to a generic version control system."
              )
             ) 
       package-list))



;;
;; PACKAGE: vm 5.31 (beta)               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/vm-5.31/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(autoload 'vm "vm" "Read mail under Emacs." t)

;; add to package-list
(setq package-list 
      (cons 
       (cons "vm" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: wais 8               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/wais.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(setq wais-path (concat (getenv "LWAISHOME") "/wais"))
(autoload 'wais wais-path "Find a wais question and go to it." t)


;; add to package-list
(setq package-list 
      (cons 
       (cons "wais" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: wais-info 1.4            
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/wais-info.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar waisq-mode-hook nil)
(setq waisq-mode-hook 
   (cons
     '(lambda () (progn (require 'wais-info)))
      waisq-mode-hook))

;; add to package-list
(setq package-list 
      (cons 
       (cons "wais-info" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: wais-steve 1.2            
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/wais-steve.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar waisq-mode-hook nil)
(setq waisq-mode-hook 
   (cons
     '(lambda () (progn (require 'wais-steve)))
      waisq-mode-hook))

;; add to package-list
(setq package-list 
      (cons 
       (cons "wais-steve" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: wais-vm 1.1            
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/wais-vm.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads
(defvar waisq-mode-hook nil)
(setq waisq-mode-hook 
   (cons
     '(lambda () (progn (require 'wais-vm)))
      waisq-mode-hook))

;; add to package-list
(setq package-list 
      (cons 
       (cons "wais-vm" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



;;
;; PACKAGE: wicos v1.4 ; 22 Sep 1992               
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/wicos.el")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "wicos" 
             (cons
              '(
                
                )
              "Save and restore multiple window configurations (wicos) within emacs."
              )
             ) 
       package-list))



;;
;; PACKAGE: x-sb-mouse 1.6          
;;

;; set load-path
(let ((dir (file-name-directory 
            "/usr/local/ls6/emacs-18.58/lisp-ls6/x-sb-mouse-1.6/")))
  (if (smember dir load-path) ()
    (setq load-path (append load-path (list dir)))))

;; defaults and autoloads


;; add to package-list
(setq package-list 
      (cons 
       (cons "x-sb-mouse" 
             (cons
              '(
                
                )
              ""
              )
             ) 
       package-list))



