/*
 * Copyright (C) 1994, 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * $Log: etalklib.h,v $
 * Revision 1.14  1995/05/27  01:37:53  zappo
 * Added new fn from etl_x.c
 *
 * Revision 1.13  1995/05/09  23:48:33  zappo
 * Added etl_cw.c prototypes
 *
 * Revision 1.12  1995/04/18  22:25:13  zappo
 * Added etl_x.c references into the list.
 *
 * Revision 1.11  1995/04/10  21:41:44  zappo
 * Added prototypes for strdup and strtok on the off chance they don't
 * exist.
 *
 * Revision 1.10  1995/04/05  00:55:12  zappo
 * Chanded a definition
 *
 * Revision 1.9  1995/03/30  02:36:31  zappo
 * Added etl_util's definitions
 *
 * Revision 1.8  1995/03/25  04:37:52  zappo
 * Typo from updating prototypes.
 *
 * Revision 1.7  1995/03/25  04:11:15  zappo
 * Updated copyright, and fixed non-ansi prototypes.
 *
 * Revision 1.6  1995/03/04  14:44:45  zappo
 * Added syslogdebug variable for debug level of syslog messages in
 * daemon.
 *
 * Revision 1.5  1995/02/01  03:39:13  zappo
 * Changed type of timeout in device, and added some functions.
 *
 * Revision 1.4  1995/01/28  16:22:41  zappo
 * Added some new ringer specific stuff
 *
 * Revision 1.3  1994/11/19  17:08:12  zappo
 * Added some new function prototypes and moved EMPTY to UNUSED
 * identifier
 *
 * Revision 1.2  1994/11/16  23:29:19  zappo
 * Moved some elements out of the talk library file.  May change it's
 * name soon.
 *
 * Revision 1.1  1994/08/29  23:42:07  zappo
 * Initial revision
 *
 */
#ifndef ETALKLIB_

#define ETALKLIB_ "ETALK library routines 0.8B (c) 1994 Free Software Foundation"

#include "config.h"

/*
 * First, lets make some of those standard define we all love
 * to use.
 */
#define TRUE 1
/* This was defined by X, but I never use it as a 0 */
#ifdef Success
#undef Success
#endif
#define Success 1
#define FALSE 0
#define Fail 0

/*
 * Define an object which will be the input interface for
 * multiple sets of ports and types of input devices.
 */
enum InputDeviceType { IO_TTY = 0, IO_TCP = 1, IO_UDP = 2, IO_X = 3 };

enum InputState { UNUSED = 0, CONNECTED = 1, LISTENING = 2, WAITING = 3,
		    IDLE = 4, DEAD = 5 };

enum DMN_deletion_type { DMN_invite, DMN_announce };

struct InputDevice {
  enum InputDeviceType type;	/* type of IO port                   */
  enum InputState      state;	/* current state                     */
  char                *name;	/* logical name to keep trak of this */
  struct sockaddr_in   raddr;	/* socket address of remote /listing */
  struct sockaddr_in   lraddr;	/* recv anyone, this is last snder   */
  struct sockaddr_in   laddr;	/* socket address of local's name    */
  int                  fd;	/* file descriptor                   */
  struct HostObject   *host;	/* host we are attached to           */
  long                 sendc;	/* number of send char/units         */
  long                 recvc;	/* number of recieve char/units      */
  void               (*readme)();/* what to do when there is input   */
  int                  timeout;	/* when to timeout (global seconds)  */
  void               (*timefn)(); /* what to do when there is no input */
  void               (*timemsg)(); /* msg to print when there is no input */
				
  struct InputDevice  *next;	/* closure                           */
  struct InputDevice  *prev;	/* closure                           */
};

/*
 * Describe hosts structures.  Host structures are only used
 * when attempting to connect to a hosts TALKD, and that is 
 * what all states represent.
 */
				/* GTALKD is stub for later */
enum DaemonType { OTALKD = 0, NTALKD = 1, GTALKD = 2 };
enum RCFileType { RC_system, RC_local, RC_new, RC_changed };

struct HostObject {
  char               *name;	/* official name of the machine     */
  enum DaemonType     type;	/* type of the daemon               */
  enum RCFileType     rc;	/* where was daemon info from       */
  struct sockaddr_in  addr;	/* host address structure.          */
  int                 addr_len;	/* length of address from host ent  */
  struct HostObject  *next;	/* closure                          */
  struct HostObject  *prev;	/* closure                          */
};

/* There needs to be a verbose and syslogdebug variable defined in main.
 */
extern int verbose;
extern int syslogdebug;

/*
 * Now lets advertise some function prototypes used in
 * controlling objects.
 */
#ifdef PROTOTYPES
/* etl_dev.c */
extern struct InputDevice *ET_gen_iodev(enum InputDeviceType type, int                  fd, struct sockaddr_in  *raddr);
extern struct sockaddr_in ET_portable_address(struct InputDevice *dev);
extern int ET_select_all(void *Ctxt, struct InputDevice *reton);
extern void ET_close_all(void *Ctxt);
extern struct InputDevice *ET_tty();
extern int ET_send(struct InputDevice *dev, void *buffer, int size);
extern int ET_recv(struct InputDevice *dev, void *buffer, int size);
extern char *ET_dev_name(struct InputDevice *io);
extern void ET_end_recursion();
extern void ET_print_q_list();
extern void ET_clean_dev(struct InputDevice *io);
extern void ET_clean();
extern void ET_print_device(struct InputDevice *io);
extern void print_swapped_sockaddr(struct sockaddr *addr);
extern void print_sockaddr(struct sockaddr *addr);

/* etl_tcp.c */
extern struct InputDevice *TCP_listen();
extern struct InputDevice *TCP_connect(struct sockaddr *addr);
extern struct InputDevice *TCP_accept(struct InputDevice *listening);

/* etl_udp.c */
extern struct sockaddr_in *UDP_receive_port();
extern void                UDP_setup_localport();
extern struct InputDevice *UDP_host(char *machine);
extern int                 UDP_daemon_change( struct InputDevice *io );
extern struct InputDevice *UDP_servent(const char *servent_name);
extern struct InputDevice *UDP_byaddr(struct InputDevice *dev, struct sockaddr_in *addr);
extern struct InputDevice *UDP_stdin();
extern void                UDP_reset_ports();

/* etl_host.c */
extern struct HostObject *HOST_gen_local_host();
extern struct HostObject *HOST_gen_host( char *machine );
extern struct HostObject *HOST_gen_host_by_addr( struct sockaddr *addr, int size );
extern void               HOST_print();

/* etl_ring.c */
extern int RING_activate(int *rf, struct InputDevice *rs, void (*rm)());
extern int RING_deactivate();
extern struct InputDevice *RING_open(char *ringfile, struct InputDevice *udp);
extern void RING_print_control();
extern void RING_print_response();

/* etl_msgm.c */
extern char *msg_types[];
extern char *msg_responses[];
extern int control_size(enum DaemonType type);
extern int response_size(enum DaemonType type);
extern void ETM_control_print(enum DaemonType type);
extern int DMN_check_compile();
extern int Response_Display(union ctl_response *response, struct InputDevice *io);
extern int ETM_response_print(enum DaemonType type);

/* etl_util.c */
extern int ETL_scmp(const char *s1, const char *s2, int   len);
#ifndef HAVE_STRDUP
extern char *strdup(const char *__s);
#endif
#ifndef HAVE_STRTOK
extern char *strtok(char *__s, const char *__delim);
#endif

/* etl_cw.c */
extern void CW_display_copywrite();

#ifdef _XLIB_H_
/* etl_x.c */
extern struct InputDevice *ETL_x(Display *display);
extern int ETL_get_resource(Display *display, char *name, char *class, XrmValue *value);

#endif /* _XLIB_H_ */

#else
/* etl_dev.c */
extern struct InputDevice *ET_gen_iodev();
extern struct sockaddr_in ET_portable_address();
extern int ET_select_all();
extern void ET_close_all();
extern struct InputDevice *ET_tty();
extern int ET_send();
extern int ET_recv();
extern char *ET_dev_name();
extern void ET_end_recursion();
extern void ET_print_q_list();
extern void ET_clean_dev();
extern void ET_clean();
extern void ET_print_device();
extern void print_swapped_sockaddr();
extern void print_sockaddr();

/* etl_tcp.c */
extern struct InputDevice *TCP_listen();
extern struct InputDevice *TCP_connect();
extern struct InputDevice *TCP_accept();

/* etl_udp.c */
extern struct sockaddr_in *UDP_receive_port();
extern void                UDP_setup_localport();
extern struct InputDevice *UDP_host();
extern int                 UDP_daemon_change();
extern struct InputDevice *UDP_servent();
extern struct InputDevice *UDP_byaddr();
extern struct InputDevice *UDP_stdin();
extern void                UDP_reset_ports();

/* etl_host.c */
extern struct HostObject *HOST_gen_local_host();
extern struct HostObject *HOST_gen_host();
extern struct HostObject *HOST_gen_host_by_addr();
extern void               HOST_print();

/* etl_ring.c */
extern int RING_activate();
extern int RING_deactivate();
extern struct InputDevice *RING_open();
extern void RING_print_control();
extern void RING_print_response();

/* etl_msgm.c */
extern char *msg_types[];
extern char *msg_responses[];
extern int control_size();
extern int response_size();
extern void ETM_control_print();
extern int DMN_check_compile();
extern int Response_Display();
extern int ETM_response_print();

/* etl_util.c */
extern int ETL_scmp();
#ifndef HAVE_STRDUP
extern char *strdup();
#endif
#ifndef HAVE_STRTOK
extern char *strtok();
#endif

/* etl_cw.c */
extern void CW_display_copywrite();

#ifdef _XLIB_H_
/* etl_x.c */
extern struct InputDevice *ETL_x();
extern int ETL_get_resource();

#endif /* _XLIB_H_ */

#endif

#endif /* etalklib_ */
