########################## -*- Mode: Perl -*- ##########################
##
## File             : Spanish.pm
##
## Description      : SFgate messages in spanish
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:51:46 1996
##
## $State: Exp $
##
## $Id: Spanish.pm,v 5.1.1.1 1996/12/23 12:51:35 goevert Exp goevert $
##
## $Log: Spanish.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:35  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:46  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/05/31 15:45:43  goevert
## patch14: language handling changed (SFgate-server)
##
## Revision 5.0.1.2  1996/05/15 17:07:59  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:41  goevert
## patch1:
##
########################################################################

# Thanks to Javier Simo <jsimo@iepala.gn.apc.org>
# for providing these translations


package SFgate::Language::Spanish;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|y'; 
$or_regexp        = 'or|o';
$not_regexp       = 'not|no';

$plaintext_regexp = 'text|plain|strict|exacto';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',            'No description available.',
             'print_wsrc',            'Wais source description could not be parsed:',
             'init_plain1',        'Ha escogido <B>un</B> documento:',
             'init_plain2',        'Ha escogido <B>',
             'init_plain3',        '</B> documentos:',
             'init_plain4',        '&#161;No ha escogido ning&uacute;n documento!',
             'init_plain5',        'Las bases de datos seleccionadas contienen <B>un</B> documento que responde a su consulta:',
             'init_plain6',        'Las bases de datos seleccionadas contienen <B>',
             'init_plain7',        '</B> documentos que responden a su consulta:',
             'init_plain8',        'Las bases de datos seleccionadas no contienen <B>ning&uacute;n</B> documento que responda a su consulta.',
             'init_plain9',           'Conversion of documents:',
             'init_plain10',       'Seleccione algunos de los siguientes documentos:',
             'init_plain11',       'traer documentos',
             'init_plain12',       'otra opci&oacute;n',
             'init_plain13',          'Prior documents...',
             'init_form1',         'Las bases de datos seleccionadas contienen <B>una</B> descripcin de base de datos que responde a su consulta:',
             'init_form2',         'Las bases de datos seleccionadas contienen <B>',
             'init_form3',         '</B> descripciones de bases de datos que responden a su consulta:',
             'init_form4',         'Seleccione algunas de las siguientes bases de datos e introduzca su consulta:',
             'init_form5',         'comenzar la b&uacute;squeda',
             'init_form6',         'anular consulta',
             'print_anchor1',      'Base de datos:',
             'print_anchor2',      'Tama&ntilde;o:',
             'print_anchor3',      'Tipo:',
             'print_anchor4',         'Score:',
             'print_diagnostics1', 'Diagn&oacute;stico',
             'print_diagnostics2', 'Servidor <B>',
             'print_diagnostics3', '</B> devuelve el siguiente diagn&oacute;stico:',
             # search_index.pl
             'do_request1',        'no pudo traer el documento:',
             'do_request2',        'Documentos WAIS',
             'do_request3',        '&#161;Intente cogerlo directamente!',
             'do_request4',        'depurar',
             'do_request5',           'You didn\'t specify a query.',
             'do_request6',        'en',
             'do_request7',           'You didn\'t select any databases.',
             'print_queries1',     'Su consulta ha sido:',
             'print_queries2',        'Queries in Databases:',
             'print_forms',           'Refine your query',
             'dumpenv',            'Volcar entorno',
             'print_footer1',         'Further documents...',
             'print_footer2',      'Esta pgina fue generada por',
             'do_sorry1',          'Error de sintaxis en la consulta',
             'do_sorry2',          '&#161;Lo siento! No puedo analizar su consulta:',
             'main1',              'terminado',
             'main2',              'termin&oacute; con el mensaje',
             'main3',              'Por favor, contacte con el administrador de WWW.',
             'main4',              'Error extra&ntilde;o',
             'main5',              'no es',
             'main6',              'Entonces, &#191;quien me ha llamado?',
             # query.pl
             'translate_query',       'Couldn\'t parse date field',
             # parse_query.pl
             'parse_query1',       'fin de consulta despu&eacute;s de operador',
             'parse_query2',       'par&eacute;ntesis de cierre inesperado',
             'parse_query3',       'corchete de cierre inesperado',
             'parse_query4',       'operador inesperado',
             'parse_query5',       'predicado num&eacute;rico inesperado',
             'parse_query6',       'inesperados',
             'parse_query7',       'falta la consulta despu&eacute;s de un par&eacute;ntesis de apertura',
             'parse_query8',       'falta el par&eacute;ntesis de cierre',
             'parse_query9',       'no hay delimitador de b&uacute;squeda literal:',
             'parse_query10',      'operador atleast sin argumento num&eacute;rico',
             'parse_query11',      'operador atleast sin t&eacute;rmino',
             'parse_query12',      'imposible anidar indextypelists',
             'parse_query13',      'falta corchete de apertura despu&eacute;s de indextypelist',
             'parse_query14',      'falta consulta despu&eacute;s de indextypelist',
             'parse_query15',      'falta corchete de cierre despu&eacute;s de indextypelist',
             'parse_query16',      'no hay t&eacute;rmino con indextype',
             'parse_query17',      'operador de proximidad',
             'parse_query18',      'sin argumento num&eacute;rico mayor que 0',
             'parse_query19',      'sin segundo argumento',
             'parse_query20',      'no son posibles expresiones de campos anidadas',
             'parse_query21',      'argumento no num&eacute;rico con predicado num&eacute;rico',
             'parse_query22',      'falta la consulta en expresi&oacute;n de campo'
             );


1;
