########################## -*- Mode: Perl -*- ##########################
##
## File             : Portuguese.pm
##
## Description      : SFgate messages in portuguese
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:52:02 1996
##
## $State: Exp $
##
## $Id: Portuguese.pm,v 5.1.1.1 1996/12/23 12:51:32 goevert Exp goevert $
##
## $Log: Portuguese.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:32  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:44  goevert
## *** empty log message ***
##
## Revision 5.0.1.1  1996/11/04 13:10:38  goevert
## patch21: new language extensions
##
########################################################################

# Thanks to Jose Eduardo M. de Barros <deBarros@bicc.uni-bonn.de>
# for providing these translations


package SFgate::Language::Portuguese;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|e'; 
$or_regexp        = 'or|ou';
$not_regexp       = 'not|n&atildeo';

$plaintext_regexp = 'text|plain|strict|exato';
$soundex_regexp   = 'soundex|semelhante';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'N&atildeo h&aacute descri&ccedil&atildeo.',
             'print_wsrc',         'A avalia&ccedil&atildeo da descri&ccedil&atildeo do banco de dados n&atildeo pode ser feita:',
             'init_plain1',        'Voc&ecirc escolheu <B>um</B> documento:',
             'init_plain2',        'Voc&ecirc escolheu <B>',
             'init_plain3',        '</B> documentos:',
             'init_plain4',        'Voc&ecirc n&atildeo escolheu nenhum documento!',
             'init_plain5',        'Existe s&oacute <B>um</B> documento que corresponde a sua pergunta nos BD escolhidos:',
             'init_plain6',        'Existem <B>',
             'init_plain7',        '</B> documentos que correspondem a sua pergunta nos BD escolhidos:',
             'init_plain8',        'N&atildeo existe <B>nenhum</B> documento que corresponda a sua pergunta.',
             'init_plain9',        'Conver&ccedil&atildeo dos documentos:',
             'init_plain10',       'Escolha alguns dos seguintes documentos:',
             'init_plain11',       'solicite os documentos',
             'init_plain12',       'nova escolha',
             'init_plain13',       'Documentos anteriores...',
             'init_form1',         'Existe s&oacute <B>uma</B> descri&ccedil&atildeo do banco de dados que corresponde a sua quest&atildeo:',
             'init_form2' ,        'Existem s&oacute <B>',
             'init_form3',         '</B> descri&ccediles do banco de dados que corresponde a sua pergunta:',
             'init_form4',         'Escolha alguns dos seguintes banco de dados e fa&ccedila a sua pergunta:',
             'init_form5',         'inicie a busca',
             'init_form6',         'anule a busca',
             'print_anchor1',      'Banco de dados:',
             'print_anchor2',      'Tamanho:',
             'print_anchor3',      'Tipo:',
             'print_anchor4',      'Placar:',
             'print_diagnostics1', 'Diagnosticos',
             'print_diagnostics2', 'O Servidor <B>',
             'print_diagnostics3', '</B> fez os seguintes diagnosticos:',
             # search_index.pl
             'do_request1',        'n&atildeo foi poss&iacutevel encontrar o documento:',
             'do_request2',        'documentos WAIS ',
             'do_request3',        'Tente retir&aacute-lo diretamente!',
             'do_request4',           'debug',
             'do_request5',        'Voc&ecirc n&atildeo fez nenhuma quest&atildeo.',
             'do_request6',        'no',
             'do_request7',        'Voc&ecirc n&atildeo escolheu nenhum Banco de Dados.',
             'print_queries1',     'Sua pergunta foi:',
             'print_queries2',     'Perguntas nos Bancos de Dados:',
             'print_forms',        'Redifina a sua pergunta',
             'dumpenv',               'Dump Environment',
             'print_footer1',      'Documentos posteriores...',
             'print_footer2',      'Esta p&aacutena foi feita por',
             'do_sorry1',          'Erro de sintaxe na pergunta',
             'do_sorry2',          'Desculpe! N&atildeo &eacute poss&iacutevel avaliar a sua pergunta:',
             'main1',              'acabou',
             'main2',              'acabou com seg. a menssagem',
             'main3',              'Favor contatar o  webmaster.',
             'main4',              'Erro estranho',
             'main5',              'n&atildeo &eacute',
             'main6',              'Como foi que me chamou?',
             # query.pl
             'translate_query',    'N&atildeo foi poss&iacutevel avaliar a data',
             # parse_query.pl
             'parse_query1',       'A pergunta terminou ap&oacutes o operador',
             'parse_query2',       'fecha parentese inesperado',
             'parse_query3',       'fecha bracket inesperado',
             'parse_query4',       'operador inesperado',
             'parse_query5',       'predicado numerico inesperado',
             'parse_query6',       'inesperado',
             'parse_query7',       'falta a pergunta ap&oacutes abrir parenteses',
             'parse_query8',       'falta fechar parenteses',
             'parse_query9',       'falta separador para busca literal',
             'parse_query10',      'ao menos um operador sem argumento num&eacuterico',
             'parse_query11',      'ao menos um operador s/ o seu valor correspondente',
             'parse_query12',         'nested indextypelists not possible',
             'parse_query13',         'missing opening bracket after indextypelist',
             'parse_query14',         'missing query after indextypelist',
             'parse_query15',         'missing closing bracket after indextypelist',
             'parse_query16',      'nenhum valor com indextype',
             'parse_query17',      'operador para semelhan&ccedila',
             'parse_query18',         'without numeric argument greater than zero',
             'parse_query19',      'sem o segundo valor',
             'parse_query20',         'nested fieldexpressions not possible',
             'parse_query21',         'non numeric argument with numeric predicate',
             'parse_query22',      'falta a pergunta no campo fieldexpression'
             );


1;
