########################## -*- Mode: Perl -*- ##########################
##
## File             : Italian.pm
##
## Description      : SFgate messages in italian
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : Tue Mar  5 13:33:38 1996
##
## Last Modified By : Norbert Goevert
## Last Modified On : Thu Nov 21 12:52:16 1996
##
## $State: Exp $
##
## $Id: Italian.pm,v 5.1.1.1 1996/12/23 12:51:29 goevert Exp goevert $
##
## $Log: Italian.pm,v $
## Revision 5.1.1.1  1996/12/23 12:51:29  goevert
## patch6: introduction of $wildcard_regexp
##
## Revision 5.1  1996/11/05 16:55:41  goevert
## *** empty log message ***
##
## Revision 5.0.1.3  1996/05/31 15:45:35  goevert
## patch14: changed file name
## patch14: language handling changed (SFgate-server)
## patch14: further translations
##
## Revision 5.0.1.2  1996/05/15 17:07:56  goevert
## patch10:
##
## Revision 5.0.1.1  1996/05/13 11:29:37  goevert
## patch1:
##
########################################################################

# thanks to Leopoldo Saggin <lsaggin@civ.bio.unipd.it>
# for providing these translations


package SFgate::Language::Italian;

use strict;
no strict 'vars';

# make perl -w happy
$and_regexp       = '';
$or_regexp        = '';
$not_regexp       = '';

$plaintext_regexp = '';
$soundex_regexp   = '';
$phonix_regexp    = '';
$wildcard_regexp  = '';

%language         = ();


## #####################################################################
## settings
## #####################################################################

$and_regexp       = 'and|e'; 
$or_regexp        = 'or|oppure|o';
$not_regexp       = 'not|non';

$plaintext_regexp = 'text|plain|strict|exacto';
$soundex_regexp   = 'soundex';
$phonix_regexp    = 'phonix';
$wildcard_regexp  = 'wildcard';

%language = (
             # client_common
             'parse_wsrc',         'Nessuna descrizione disponibile.',
             'print_wsrc',         'Non &egrave; possibile analizzare la descrizione del sorgente Wais:',
             'init_plain1',        'E\' stato selezionato <B>un</B> documento:',
             'init_plain2',        'Sono stati selezionati <B>',
             'init_plain3',        '</B> documenti:',
             'init_plain4',        'Non &egrave; stato selezionato alcun documento!',
             'init_plain5',        'I database selezionati contengono <B>un</B> documento che soddisfa l\'interrogazione posta:',
             'init_plain6',        'I database selezionati contengono <B>',
             'init_plain7',        '</B> documenti che soddisfano l\'interrogazione posta:',
             'init_plain8',        'I database selezionati <B>non</B> contengono alcun documento che soddisfa l\'interrogazione posta.',
             'init_plain9',        'Conversione dei documenti:',
             'init_plain10',       'Seleziona qualcuno tra i seguenti documenti:',
             'init_plain11',       'preleva i documenti',
             'init_plain12',       'altra scelta',
             'init_plain13',       'Documenti precedenti...',
             'init_form1',         'I database selezionati contengono <B>una</B> descrizione di database che soddisfa l\'interrogazione posta:',
             'init_form2',         'I database selezionati contengono <B>',
             'init_form3',         '</B> descrizioni di database che soddisfano l\'interrogazione posta:',
             'init_form4',         'Seleziona qualcuno tra i seguenti database e formula un\'interrogazione:',
             'init_form5',         'inizia la ricerca',
             'init_form6',         'altra ricerca',
             'print_anchor1',      'Database:',
             'print_anchor2',      'Dimensioni:',
             'print_anchor3',      'Tipo:',
             'print_anchor4',      'Punteggio:',
             'print_diagnostics1', 'Diagnostico',
             'print_diagnostics2', 'Il Server <B>',
             'print_diagnostics3', '</B> restituisce il seguente diagnostico:',
             # search_index.pl
             'do_request1',        'impossibile recuperare il documento:',
             'do_request2',        'Documenti WAIS',
             'do_request3',        'Cerca di recuperarlo direttamente!',
             'do_request4',        'debug',
             'do_request5',        'Non &egrave; stata specificata alcuna interrogazione.',
             'do_request6',        'in',
             'do_request7',        'Non &egrave; stato selezionato alcun database.',
             'print_queries1',     'L\'interrogazione posta era:',
             'print_queries2',     'Interrogazioni dei Databases:',
             'print_forms',        'Definire meglio l\'interrogazione',
             'dumpenv',               'Dump Environment',
             'print_footer1',      'Ulteriori documenti...',
             'print_footer2',      'Questa pagina &egrave; stata creata da',
             'do_sorry1',          'Errore di sintassi nell\'interrogazione',
             'do_sorry2',          'Spiacente! Non riesco ad analizzare l\'interrogazione:',
             'main1',              'terminato',
             'main2',              'terminato con il messaggio',
             'main3',              'Per favore, contattate l\'amministratore del WWW.',
             'main4',              'Errore strano',
             'main5',              'non &egrave;',
             'main6',              'Chi mi chiama poi?',
             # query.pl
             'translate_query',    'Non &egrave; possibile analizzare il campo data',
             # parse_query.pl
             'parse_query1',       'Fine dell\'interrogazione dopo l\'operatore',
             'parse_query2',       'Parentesi di chiusura inaspettata',
             'parse_query3',       'Parentesi quadra di chiusura inaspettata',
             'parse_query4',       'Operatore inaspettato',
             'parse_query5',       'Predicato numerico inaspettato',
             'parse_query6',       'inaspettato',
             'parse_query7',       'interrogazione mancante dopo l\'apertura delle parentesi',
             'parse_query8',       'parentesi di chiusura assente',
             'parse_query9',       'nessun delimitatore di ricerca letterale',
             'parse_query10',      'operatore atleast privo di argomento numerico',
             'parse_query11',      'operatore atleast privo di termine',
             'parse_query12',      'indextypelists nidificate impossibili',
             'parse_query13',      'parentesi quadra di chiusura assente dopo indextypelist',
             'parse_query14',      'interrogazione mancante dopo indextypelist',
             'parse_query15',      'parentesi quadra di chiusura assente dopo indextypelist',
             'parse_query16',      'nessun termine con indextype',
             'parse_query17',      'operatore di prossimit&agrave;',
             'parse_query18',      'senza argomento numerico maggiore di 0',
             'parse_query19',      'senza secondo termine',
             'parse_query20',      'fieldexpressions nidificate impossibili',
             'parse_query21',      'argomento non numerico con predicato numerico',
             'parse_query22',      'interrogazione mancante nella fieldexpression'
             );


1;
