######################### -*- Mode: Perl -*- #########################
##
## File          : $Basename: Linear.pm $
##
## Author        : Norbert Goevert
## Created On    : Thu Dec 10 16:38:57 1998
## Last Modified : Time-stamp: <2000-11-20 08:01:11 goevert>
##
## Description   : LSP approach for linear functions and binary
##                 relevance scales
##
## $Id: Linear.pm 1.5 Wed, 29 Nov 2000 09:57:57 +0100 goevert $
## $ProjectHeader: LSP 2.6 Wed, 29 Nov 2000 09:57:57 +0100 goevert $
##
######################################################################


use strict;


=pod #---------------------------------------------------------------#

=head1 NAME

LSP::Binary::Linear - LSP approach for linear functions and binary
                      relevance scales

=head1 SYNOPSIS

  require LSP::Binary::Linear;
  $LSP = new LSP $dimension;
  $LSP->add_vector($vector, $scalar1, $scalar2)
  $LSP = function LSP::Binary::Linear $coefficients;

=head1 DESCRIPTION

LSP::Binary::Linear is a combination of LSP::Linear(3) and
LSP::Binary(3).

=head1 METHODS

See LSP(3).

=cut #---------------------------------------------------------------#


package LSP::Binary::Linear;


use base qw(LSP::Binary);


our $VERSION;
'$ProjectVersion: 2.6 $ ' =~ /(\d+)\.(\d+)/; $VERSION = sprintf '%d.%03d', $1, $2;


## public ############################################################

sub add_vector {

  my $self = shift;
  my($vector, $scalar1, $scalar2) = @_;

  return $self->_fail("Wrong dimension of vector ( @$vector ).")
    if @$vector ne $self->{dimension};

  my $vec_v   = new Math::Matrix [ 1, @$vector ];
  my $vec_v_t = $vec_v->transpose;
  my $vec_v_v = $vec_v_t->multiply($vec_v);

  if ($scalar1 == 1) {
    $self->{momental}->add_to($vec_v_v->concat($vec_v_t));
  } elsif ($scalar1 != 0) {
    $self->{momental}->add_to($vec_v_v->concat($vec_v_t)->scalarproduct($scalar1));
  }
  if ($scalar2 == 1) {
    $self->{momental}->add_to($vec_v_v->concat($self->{vec_vy}));
  } elsif ($scalar2 != 0) {
    $self->{momental}->add_to($vec_v_v->scalarproduct($scalar2)->concat($self->{vec_vy}));
  }
}


## private ###########################################################

sub _create_function {

  my $self = shift; 

  my $string = '';
  foreach my $i (0 .. $self->{dimension}) {
    my $comp = '';
    if ($self->{solution}->[$i]->[0] == 1) {
      $comp = '+ ';
    } elsif ($self->{solution}->[$i]->[0] < 0) {
      $comp = '- ' . abs($self->{solution}->[$i]->[0]);
    } elsif ($self->{solution}->[$i]->[0] > 0) {
      $comp = '+ ' . $self->{solution}->[$i]->[0];
    } else {
      next;
    }
    $comp .= ' * $v->[' . ($i-1) . ']' if $i;  
    $string .= $comp . "\n  ";
  }

  $string =~ s/^[+-] //;
  $string =~ s/\n  $/;/;
  $string = "sub {\n\n  my \$v = shift;\n\n  " . $string . "\n}\n";
  
  #print $string;
  
  $self->{_function} = eval $string;
}


=pod #---------------------------------------------------------------#

=head1 BUGS

Yes. Please let me know!

=head1 SEE ALSO

LSP::Linear(3),
LSP::Binary(3),
LSP::Binary::Linear(3),
Math::Matrix(3),
perl(1).

=head1 AUTHOR

Norbert GE<ouml>vert E<lt>F<goevert@ls6.cs.uni-dortmund.de>E<gt>

=cut #---------------------------------------------------------------#


1;
__END__
