/************************************************************************
*                                                                       *
*       Adding an X-Window interface to SMART --- smart_xsec_ui.c       *
*                                                                       *
*                                                                       *
*    by: Victuria Chiu, senior in CS from Univ. of Cal. at Berkeley,    *
*                e-mail: victoria@csr.lbl.gov                           *
*                                                                       *
*        Tong Li, graduate student in CS from Oregon State University,  *
*                e-mail: lit@mist.cs.orst.edu                           *
*                                                                       *
*    at Lawrence berkeley Laboratory, Summer 1991                       *
*                                                                       *
************************************************************************/
/*
 * Smart_xsec_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `smart_xsec.G'.
 * THIS FILE HAS BEEN ALTERED BY HAND. Therefore gxv is disabled to avoid
 * overwriting this file.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "smart_xsec_ui.h"
#include <gcm.h>
#include "xfunctions.h"
/*
 * Initialize an instance of object `document_popup'.
 */
smart_xsec_document_popup_objects *
smart_xsec_document_popup_objects_initialize(ip, owner)
	smart_xsec_document_popup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (smart_xsec_document_popup_objects *) calloc(1, sizeof (smart_xsec_document_popup_objects))))
		return (smart_xsec_document_popup_objects *) NULL;
	if (!ip->document_popup)
		ip->document_popup = smart_xsec_document_popup_document_popup_create(ip, owner);
	if (!ip->doc_popup_control)
		ip->doc_popup_control = smart_xsec_document_popup_doc_popup_control_create(ip, ip->document_popup);
	if (!ip->docnext_button)
		ip->docnext_button = smart_xsec_document_popup_docnext_button_create(ip, ip->doc_popup_control);
	if (!ip->docdone_button)
		ip->docdone_button = smart_xsec_document_popup_docdone_button_create(ip, ip->doc_popup_control);
	if (!ip->doc_textpane)
		ip->doc_textpane = smart_xsec_document_popup_doc_textpane_create(ip, ip->document_popup);
	return ip;
}

/*
 * Create object `document_popup' in the specified instance.

 */
Xv_opaque
smart_xsec_document_popup_document_popup_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 639,
		XV_HEIGHT, 449,
		XV_LABEL, "Document",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `doc_popup_control' in the specified instance.

 */
Xv_opaque
smart_xsec_document_popup_doc_popup_control_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 64,
		WIN_BORDER, FALSE,
		NULL);
        gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

/*
 * Create object `docnext_button' in the specified instance.

 */
Xv_opaque
smart_xsec_document_popup_docnext_button_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_docnext_document(); 
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 12,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
		PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Next",
		PANEL_EVENT_PROC, x_docnext_document,
		NULL);
	return obj;
}


/*
 * Create object `docdone_button' in the specified instance.

 */
Xv_opaque
smart_xsec_document_popup_docdone_button_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		close_doc_popup();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 112,
		XV_Y, 12,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
		PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "    Done",
		PANEL_EVENT_PROC, close_doc_popup,
		NULL);
	return obj;
}

/*
 * Create object `doc_textpane' in the specified instance.

 */
Xv_opaque
smart_xsec_document_popup_doc_textpane_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 64,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		TEXTSW_BROWSING, TRUE,
		TEXTSW_DISABLE_LOAD, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

/*
 * Initialize an instance of object `help_popup'.
 */
smart_xsec_help_popup_objects *
smart_xsec_help_popup_objects_initialize(ip, owner)
	smart_xsec_help_popup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (smart_xsec_help_popup_objects *) calloc(1, sizeof (smart_xsec_help_popup_objects))))
		return (smart_xsec_help_popup_objects *) NULL;
	if (!ip->help_popup)
		ip->help_popup = smart_xsec_help_popup_help_popup_create(ip, owner);
	if (!ip->help_popup_conrol)
		ip->help_popup_conrol = smart_xsec_help_popup_help_popup_conrol_create(ip, ip->help_popup);
	if (!ip->helppopup_msg)
		ip->helppopup_msg = smart_xsec_help_popup_helppopup_msg_create(ip, ip->help_popup_conrol);
	if (!ip->helpdone_button)
		ip->helpdone_button = smart_xsec_help_popup_helpdone_button_create(ip, ip->help_popup_conrol);
	if (!ip->help_textpane)
		ip->help_textpane = smart_xsec_help_popup_help_textpane_create(ip, ip->help_popup);
	return ip;
}

/*
 * Create object `help_popup' in the specified instance.

 */
Xv_opaque
smart_xsec_help_popup_help_popup_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 605,
		XV_HEIGHT, 500,
		XV_LABEL, "    Help ",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `help_popup_conrol' in the specified instance.

 */
Xv_opaque
smart_xsec_help_popup_help_popup_conrol_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 56,
		WIN_BORDER, FALSE,
		NULL);
        gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

/*
 * Create object `helppopup_msg' in the specified instance.

 */
Xv_opaque
smart_xsec_help_popup_helppopup_msg_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 4,
		XV_Y, 12,
		XV_WIDTH, 128,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "SMART Commands",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `helpdone_button' in the specified instance.

 */
Xv_opaque
smart_xsec_help_popup_helpdone_button_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		close_help_popup();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 24,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
		PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "   Done",
		PANEL_EVENT_PROC, close_help_popup,
		NULL);
	return obj;
}

/*
 * Create object `help_textpane' in the specified instance.

 */
Xv_opaque
smart_xsec_help_popup_help_textpane_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 52,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		TEXTSW_BROWSING, TRUE,
		TEXTSW_DISABLE_LOAD, TRUE,
		NULL);
        gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

/*
 * Initialize an instance of object `savelast_popup'.
 */
smart_xsec_savelast_popup_objects *
smart_xsec_savelast_popup_objects_initialize(ip, owner)
	smart_xsec_savelast_popup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (smart_xsec_savelast_popup_objects *) calloc(1, sizeof (smart_xsec_savelast_popup_objects))))
		return (smart_xsec_savelast_popup_objects *) NULL;
	if (!ip->savelast_popup)
		ip->savelast_popup = smart_xsec_savelast_popup_savelast_popup_create(ip, owner);
	if (!ip->savelast_popup_control)
		ip->savelast_popup_control = smart_xsec_savelast_popup_savelast_popup_control_create(ip, ip->savelast_popup);
	if (!ip->savelast_filetext)
		ip->savelast_filetext = smart_xsec_savelast_popup_savelast_filetext_create(ip, ip->savelast_popup_control);
	if (!ip->savelast_ok_button)
		ip->savelast_ok_button = smart_xsec_savelast_popup_savelast_ok_button_create(ip, ip->savelast_popup_control);
	return ip;
}

/*
 * Create object `savelast_popup' in the specified instance.

 */
Xv_opaque
smart_xsec_savelast_popup_savelast_popup_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 400,
		XV_HEIGHT, 150,
		XV_LABEL, "Save Last Command",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `savelast_popup_control' in the specified instance.

 */
Xv_opaque
smart_xsec_savelast_popup_savelast_popup_control_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `savelast_filetext' in the specified instance.

 */
Xv_opaque
smart_xsec_savelast_popup_savelast_filetext_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		get_text();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 52,
		XV_WIDTH, 215,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Filename:",
		PANEL_VALUE_X, 99,
		PANEL_VALUE_Y, 72,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_READ_ONLY, FALSE,
		PANEL_EVENT_PROC, get_text,
		NULL);
	return obj;
}

/*
 * Create object `savelast_ok_button' in the specified instance.

 */
Xv_opaque
smart_xsec_savelast_popup_savelast_ok_button_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		x_savelast();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 152,
		XV_Y, 104,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "    OK",
		PANEL_EVENT_PROC, x_savelast,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `advance_popup'.
 */
smart_xsec_advance_popup_objects *
smart_xsec_advance_popup_objects_initialize(ip, owner)
	smart_xsec_advance_popup_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (smart_xsec_advance_popup_objects *) calloc(1, sizeof (smart_xsec_advance_popup_objects))))
		return (smart_xsec_advance_popup_objects *) NULL;
	if (!ip->advance_popup)
		ip->advance_popup = smart_xsec_advance_popup_advance_popup_create(ip, owner);
	if (!ip->adv_popup_control)
		ip->adv_popup_control = smart_xsec_advance_popup_adv_popup_control_create(ip, ip->advance_popup);
	if (!ip->advdone_button)
		ip->advdone_button = smart_xsec_advance_popup_advdone_button_create(ip, ip->adv_popup_control);
	if (!ip->doc_textpane1)
		ip->doc_textpane1 = smart_xsec_advance_popup_doc_textpane1_create(ip, ip->advance_popup);
	return ip;
}

/*
 * Create object `advance_popup' in the specified instance.

 */
Xv_opaque
smart_xsec_advance_popup_advance_popup_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 605,
		XV_HEIGHT, 648,
		XV_LABEL, "Advanced Functions",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `adv_popup_control' in the specified instance.

 */
Xv_opaque
smart_xsec_advance_popup_adv_popup_control_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, FALSE,
		NULL);
        gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

/*
 * Create object `advdone_button' in the specified instance.

 */
Xv_opaque
smart_xsec_advance_popup_advdone_button_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		close_adv_popup();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 256,
		XV_Y, 12,
		PANEL_LABEL_WIDTH, 77,
		XV_WIDTH, 77,
		XV_HEIGHT, 19,
		PANEL_ITEM_COLOR, gcm_color_index("Red"),
		PANEL_LABEL_STRING, "    Done",
		PANEL_EVENT_PROC, close_adv_popup,
		NULL);
	return obj;
}


/*
 * Create object `doc_textpane1' in the specified instance.

 */
Xv_opaque
smart_xsec_advance_popup_doc_textpane1_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 40,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		TEXTSW_BROWSING, TRUE,
		TEXTSW_DISABLE_LOAD, TRUE,
		NULL);
        gcm_initialize_colors(obj, "Thistle", "Black");
	return obj;
}

