#ifdef RCSID
static char rcsid[] = "$Header: /home/smart/release/src/libprint/p_simp_inv.c,v 11.0 1992/07/21 18:23:37 chrisb Exp $";
#endif
/* Copyright (c) 1991, 1990, 1984 - Gerard Salton, Chris Buckley. 

   Permission is granted for use of this file in unmodified form for
   research purposes. Please contact the SMART project to obtain 
   permission for other uses.
*/

#include "common.h"
#include "param.h"
#include "functions.h"
#include "simp_inv.h"
#include "buf.h"

static SM_BUF internal_output = {0, 0, (char *) 0};

/* Print a SIMP_INV relation to stdout */
void
print_simp_inv (simp_inv, output)
SIMP_INV *simp_inv;
SM_BUF *output;
{
    long i;
    SM_BUF *out_p;
    char temp_buf[PATH_LEN];

    if (output == NULL) {
        out_p = &internal_output;
        out_p->end = 0;
    }
    else {
        out_p = output;
    }

    for (i = 0; i < simp_inv->num_list; i++) {
        (void) sprintf (temp_buf, 
                        "%ld\t%ld\t%ld\n",
                        simp_inv->id_num,
                        i,
                        simp_inv->list[i]);
        if (UNDEF == add_buf_string (temp_buf, out_p))
            return;
    }

    if (output == NULL) {
        (void) fwrite (out_p->buf, 1, out_p->end, stdout);
        out_p->end = 0;
    }
}

