/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees, and by CSNET.  No warranties of
 * any kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed without prior consent of CSNET.
 * You may direct questions to nameserv@uiuc.edu
 */

#ifndef DB_H
#define DB_H
#include "conf.h"
#define PTRTYPE long	/* type to use for record pointers */
#define PTRSIZE sizeof(PTRTYPE)	/* size of a record pointer */

/*
 * d_record sizes.  The total size should be DRECSIZE.  The number of bytes
 * for data is found by subtracting the sizes of the other fields from this. 
 */
#define NDCHARS	(DRECSIZE - 2*PTRSIZE - 2*sizeof(long) - 2*sizeof(short))

/*
 * d_ovrflo sizes.  The total size should be DOVRSIZE.  The number of bytes
 * for data is found by subtracting the sizes of the other fields from this. 
 */
#define NDOCHARS (DOVRSIZE - PTRSIZE)

/*
 * iindex sizes.  The total size should be NICHARS.  The number of pointers
 * available is dependent on the size of a pointer... 
 */
#define NIPTRS	(NICHARS/PTRSIZE)
#define NOPTRS	(NOCHARS/PTRSIZE)	/* 1K index overflow blocks */

#define EMPTY	 '\377'		/* delete signifies a once used but now empty
				 * node */
#define MAXTRIES 32
#define NHASH	32

/* structures for Nameserver database */

struct iindex
{
	union
	{
		char    ii_string[NICHARS];
		PTRTYPE ii_recptrs[NIPTRS];
	}       i_i;
};

#define i_string i_i.ii_string
#define i_recptrs i_i.ii_recptrs

struct d_record
{
	PTRTYPE d_ovrptr;		/* ptr to ovrflo block ( if any ) */
	PTRTYPE d_id;			/* unique id */
	long    d_crdate;		/* date of creation */
	long    d_chdate;		/* date of last modification */
	unsigned short d_dead;		/* deleted entry */
	unsigned short d_datalen;	/* length of data that follows */
	char    d_data[NDCHARS];	/* various strings, variable length */
};
typedef struct d_record DREC;

struct d_ovrflo
{
	char    d_mdata[NDOCHARS];
	PTRTYPE d_nextptr;		/* ptr to next ovrflo block */
};
typedef struct d_ovrflo DOVR;

struct dirhead
{				/* in block 0 of the .dir file */
	PTRTYPE nents;		/* number of entries in the .dir file */
	PTRTYPE next_id;	/* the next id capable of being issued */
	int     hashes[NHASH];	/* # of hashes to find index entries */
	int     nfree;		/* number of free entries in freelist,(not
				 * cur used) */
	int     freel[10];
};
#endif
