/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

/*
 * replaces ssn fields with id fields, using id database
 */

#include <stdio.h>
#include <cdefs.h>

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
# ifndef index
#  define index strchr
#  define rindex strrchr
# endif /* !index */
#else /* !__STDC__ */
char	*index();
#endif /* __STDC__ */

char * FindId __P((char *));
char * AssignId __P((char *));

#define BUF_SIZE    8192

main(argc, argv)
	int argc;
	char **argv;
{
	char	buffer[BUF_SIZE];
	char	*ssn1, *ssn2;
	char	*id;
	int	found = 0, assigned = 0, skipped = 0;
	int	err;
	short	assignOk = 0;
	int	count = 0;

	argc--, argv++;
	if (argc >= 1 && !strcmp(argv[0], "-a"))
	{
		argc--, argv++;
		assignOk = 1;
	}
	if (argc != 1)
	{
		fprintf(stderr, "Usage: ssnid [-a] ssndb\n");
		exit(1);
	}
	if (err = IdInit(argv[0]))
	{
		perror(argv[0]);
		exit(1);
	}
	ssn1 = buffer + 2;	/* ^5:X, where X is the beginning of SSN */
	while (gets(buffer) != NULL)
	{
		if (++count % 500 == 0)
			fprintf(stderr, "%d\r", count);
		ssn2 = index(ssn1, '\t');	/* find end of ssn */
		if (!ssn2)
			continue;	/* skip */

		*ssn2 = '\0';
		if (id = FindId(ssn1))
			found++;
		else if (assignOk)
		{
			id = AssignId(ssn1);
			assigned++;
		} else
		{
			id = "<none>";
			skipped++;
		}
		printf("5:%s\t%s\n", id, ssn2 + 1);
	}
	fprintf(stderr, "Found %d, assigned %d, skipped %d.\n", found, assigned, skipped);
	IdDone();
	exit(0);
}
