/* text_append.c -- routines to perform text appends.  Very ugly.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 22 11:06:26 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>


static int _text_position;

/* This is *required* for use with XawAsciiAppend, which *must* poke into
 * the private portions to work properly.  Very ugly indeed.
 */
XawTextPosition (*TextSrcScanProc)();


/* These routines will append a string to an *existing* asciiTextWidget.
 * Thus, if called before the widget is realized, you *will* dump core.
 * The routine assumes the widget is read-only.
 * This is a horrendous hack, but I know of no other way to do this.
 */
int XawAsciiGetEndPosition(widget)
Widget widget;
{
   Widget source;
   int length;

   XtVaGetValues(widget, XtNtextSource, &source, NULL);
   length = (*TextSrcScanProc)(source, 0, XawstAll, XawsdRight, 1, True);

   return(length);
}

void XawAsciiAppend(widget, text)
Widget widget;
char *text;
{
   XawTextBlock xawtb;
   int length;
   Widget source;

   /* Describe the text that we want to append. */
   xawtb.ptr = text;
   xawtb.length = strlen(text);
   xawtb.firstPos = 0;
   xawtb.format = FMT8BIT;

   /* Next, determine the end-position of the text in the widget.
    */
   length = XawAsciiGetEndPosition(widget);

   /* Finally, do a text replace while changing modes.  By
    * specifying start and end as length, we accomplish an insert.
    */
   XtVaSetValues(widget, XtNeditType, XawtextAppend, NULL);
   XawTextReplace(widget, length, length, &xawtb);
   XtVaSetValues(widget, XtNeditType, XawtextRead, NULL);
}


/* Here are two routines to save and restore the text position. */
int XawAsciiSaveTextPosition(widget)
Widget widget;
{
   _text_position = XawAsciiGetEndPosition(widget);
}

int XawAsciiRestoreTextPosition(widget)
Widget widget;
{
   XtVaSetValues(widget, XtNinsertPosition, _text_position, NULL);
   XtCallActionProc(widget, "redraw-display", NULL, NULL, ZERO);
}
