/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* sxpm.c:
 *
 *  XPM
 *  Show XPM File program - Demo
 *  Developed by Arnaud Le Hors
 */

#include <X11/StringDefs.h>   
#include <X11/Intrinsic.h>   
#include "xpm.h"

/* XPM */
/* plaid pixmap */
static char * plaid[] = {
/* width height ncolors chars_per_pixel */ 
"22 22 4 2",
/* colors */
"   c red 	m white  s light_color",
"Y  c green	m black  s lines_in_mix",
"+  c yellow	m white  s lines_in_dark",
"x 		m black  s dark_color",
/* pixels */
"x   x   x x x   x   x x x x x x + x x x x x ", 
"  x   x   x   x   x   x x x x x x x x x x x ", 
"x   x   x x x   x   x x x x x x + x x x x x ", 
"  x   x   x   x   x   x x x x x x x x x x x ", 
"x   x   x x x   x   x x x x x x + x x x x x ", 
"Y Y Y Y Y x Y Y Y Y Y + x + x + x + x + x + ", 
"x   x   x x x   x   x x x x x x + x x x x x ", 
"  x   x   x   x   x   x x x x x x x x x x x ", 
"x   x   x x x   x   x x x x x x + x x x x x ", 
"  x   x   x   x   x   x x x x x x x x x x x ", 
"x   x   x x x   x   x x x x x x + x x x x x ", 
"          x           x   x   x Y x   x   x ", 
"          x             x   x   Y   x   x   ",
"          x           x   x   x Y x   x   x ", 
"          x             x   x   Y   x   x   ", 
"          x           x   x   x Y x   x   x ", 
"x x x x x x x x x x x x x x x x x x x x x x ", 
"          x           x   x   x Y x   x   x ", 
"          x             x   x   Y   x   x   ", 
"          x           x   x   x Y x   x   x ", 
"          x             x   x   Y   x   x   ", 
"          x           x   x   x Y x   x   x "
} ;

#define dpy XtDisplay(topw)
#define visual DefaultVisual(dpy,DefaultScreen(dpy))
#define colormap DefaultColormap(dpy,DefaultScreen(dpy))
#define depth DefaultDepth(dpy,DefaultScreen(dpy))

void kinput();

static char **command ;
static Pixel *pixels;
static unsigned int npixels;
static XpmInfo infos;
static Widget topw; 
static Pixmap pix;

main(argc, argv) unsigned int argc; char **argv;
{
    int ErrorStatus;
    unsigned int stdinf, stdoutf, nod;
    char *input, *output;
    unsigned int numsymbols;
    ColorSymbol symbols[10];
    unsigned int width, height;
    int i, resize;
    char *stype;
    XrmValue val;

    stdinf = stdoutf = nod = 0;
    input = output = NULL;
    numsymbols = 0;
    resize = 0;

    topw = XtInitialize(argv[0], "Sxpm", NULL, 0, &argc, argv);

    if (!XrmGetResource(XtDatabase(dpy), NULL, "Sxpm.geometry", &stype, &val)){
	resize = 1;
	XtResizeWidget(topw, 1, 1, 1);
    }

    command = argv ;
    for (i = 1; i < argc; i++) {
	if (strncmp(argv[i], "-in", 3) == 0) {
	    input =  argv[++i];
	    continue;
	}
	if (strncmp(argv[i], "-out", 4) == 0) {
	    output =  argv[++i];
	    continue;
	}
	if (strncmp(argv[i], "-stdin", 5) == 0) {
	    stdinf = 1;
	    continue;
	}
	if (strncmp(argv[i], "-stdout", 5) == 0) {
	    stdoutf = 1;
	    continue;
	}
	if (strncmp(argv[i], "-nod", 2) == 0) {
	    nod = 1;
	    continue;
	}
	if (strncmp(argv[i], "-s", 2) == 0) {
	    if (i < argc + 1) {
		symbols[numsymbols].name = argv[++i];
		symbols[numsymbols++].value = argv[++i];
	    }
	    continue;
	}
	if (strncmp(argv[i], "-p", 2) == 0) {
	    if (i < argc + 1) {
		symbols[numsymbols].name = argv[++i];
		symbols[numsymbols].value = NULL;
		symbols[numsymbols++].pixel = atol(argv[++i]);
	    }
	    continue;
	}
	if (strncmp(argv[i], "-rgb", 3) == 0) {
	    if (i < argc + 1) {
		infos.rgb_fname = argv[++i];
	    }
	    continue;
	}
	Usage();
    }

    XtRealizeWidget(topw);

    if (input || stdinf) {
	ErrorStatus = XReadPixmapFile(dpy, visual, XtWindow(topw), colormap,
			input, depth, &pix, &width, &height, &pixels, 
			&npixels, symbols, numsymbols, &infos);
	if (ErrorStatus != PixmapSuccess) ErrorMessage(ErrorStatus);
    } else {
	ErrorStatus = XCreatePixmapFromData(dpy, visual, XtWindow(topw), 
			colormap, plaid, depth, &pix, &width, &height, &pixels,
			&npixels, symbols, numsymbols, NULL);
	if (ErrorStatus != PixmapSuccess) ErrorMessage(ErrorStatus);
    }
    if (output || stdoutf) {
	ErrorStatus = XWritePixmapFile(dpy, colormap, output, pix, width, 
			height, NULL, 2, &infos);
	if (ErrorStatus != PixmapSuccess) ErrorMessage(ErrorStatus);
    }
    if (!nod) {
	if (resize) {
	    XtResizeWidget(topw, width, height, 1);
	}
	XtAddEventHandler(topw, KeyPressMask, False, (caddr_t)kinput, NULL);
	XSetWindowBackgroundPixmap(dpy, XtWindow(topw), pix);  
	XClearWindow(dpy, XtWindow(topw));
	XtMainLoop();
    }
    Exit(0);
}

Usage()
{
    fprintf(stderr,"\nUsage:  %s [-options...]\n", command[0]);
    fprintf(stderr,"%s\n", "Where options are:");
    fprintf(stderr,"%s\n", 
	    "[-d host:display]            Display to connect to.");
    fprintf(stderr,"%s\n", 
	    "[-g geom]                    Geometry of window.");
    fprintf(stderr,"%s\n", 
	    "[-s symbol_name color_name]  Overwrite color defaults.");
    fprintf(stderr,"%s\n", 
	    "[-p symbol_name pixel_value] Overwrite color defaults.");
    fprintf(stderr,"%s\n", 
	    "[-in filename]                Read input from file `filename`.");
    fprintf(stderr,"%s\n", 
	    "[-stdin]                     Read input from stdin.");
    fprintf(stderr,"%s\n", 
	    "[-out filename]                Write output to file `filename`.");
    fprintf(stderr,"%s\n", 
	    "[-stdout]                    Write output to stdout.");
    fprintf(stderr,"%s\n", 
	    "[-nod]                       Don't display in window.");
    fprintf(stderr,"%s\n\n", 
	    "[-rgb filename]              Search colornames in the \
rgb text file `filename`.");
    exit(0);
}


ErrorMessage(ErrorStatus)
int ErrorStatus;
{
    char *message;

    switch (ErrorStatus) {
    case PixmapOpenFailed:
	message = "Cannot open file";
	break;
    case PixmapFileInvalid:
	message = "Pixmap file invalid";
	break;
    case PixmapNoMemory:
	message = "Not enough memory";
	break;
    case PixmapParseColorFailed:
	message = "Parse color failed";
	break;
    case PixmapAllocColorFailed:
	message = "Alloc color failed";
	break;
    }
    printf("Pixmap Error: %s.\n", message);
    Exit(1);
}

Exit(i)
int i;
{
    XFreePixmap(dpy, pix);
    XFreeColors(dpy, colormap, pixels, npixels, 0);
    XFreeXpmInfo(&infos);
    if (pixels) free(pixels);
    exit(i);
}

void kinput(widget, tag, xe, b)
Widget widget;
void* tag;
XEvent *xe;
Boolean *b;
{
    char c;
    XLookupString(&(xe->xkey), &c, 1, NULL, NULL);
    if (c == 'q' || c == 'Q') 
	Exit(0);
}
