/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* XRdPixF.c:
 *
 *  XPM
 *  Read utility for XPM file format
 *  Developed by Arnaud Le Hors
 */

#include "xpmP.h"

DataType DataTypes[] = {
    "", "!", "\n", '\0', '\n', "", "", "", "", /* Natural type */
    "C", "/*", "*/\n", '"', '"', ",\n", "static char *", "[] = {\n", "};\n",
    "Lisp", ";", "\n", '"', '"', "\n", "(setq ", " '(\n", "))\n",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

int XReadPixmapFile(display, visual, d, colormap, filename, depth, 
		    pixmap_return, width_return, height_return, 
		    pixels_return, npixels_return,
		    colorsymbols, numsymbols, infos)
     Display *display;
     Visual *visual;
     Drawable d;
     Colormap colormap;
     char *filename;
     unsigned int depth;
     Pixmap *pixmap_return;
     unsigned int *width_return, *height_return;
     Pixel **pixels_return;
     unsigned int *npixels_return;
     ColorSymbol colorsymbols[];
     unsigned int numsymbols;
     XpmInfo *infos;

{ MData *mdata;
  char buf[BUFSIZ];
  int l, n = 0;
  int ErrorStatus;

  /* Initialize return values
   */
  if (pixmap_return) *pixmap_return = NULL;
  if (width_return) *width_return = 0;
  if (height_return) *height_return = 0;
  if (pixels_return) *pixels_return = NULL;
  if (npixels_return) *npixels_return = 0;

  if ((ErrorStatus = mreadopen(filename, &mdata)) != PixmapSuccess)
      return(ErrorStatus);

  /* parse the header file
   */
  mdata->Bos = '\0';
  mdata->Eos = '\n';
  mdata->Bcmt = mdata->Ecmt = NULL;
  mnextw(mdata, buf);		/* skip the first word */
  l = mnextw(mdata, buf);	/* then get the second word */
  if ((l == 3 && !strncmp("XPM", buf, 3)) || 
      (l == 4 && !strncmp("XPM2", buf, 4))) {
      if (l == 3)
	  n = 1;			/* handle XPM as XPM2 C */
      else {
	  l = mnextw(mdata, buf);	/* get the type key word */
 
	  /* get infos about this type
	   */
	  while (DataTypes[n].type && strncmp(DataTypes[n].type, buf, l)) n++;
      }
      if (DataTypes[n].type) {
	  if (infos) {
	      infos->type = (char *) malloc(l+1);
	      strncpy(infos->type, buf, l);
	      infos->type[l] = '\0';
	  }
	  if (n == 0) {		/* natural type */
	      mdata->Bcmt = DataTypes[n].Bcmt;
	      mdata->Ecmt = DataTypes[n].Ecmt;
	      mnextstring(mdata);	/* skip the end of headerline */
	      mdata->Bos = DataTypes[n].Bos;
	  } else {
	      mnextstring(mdata);	/* skip the end of headerline */
	      mdata->Bcmt = DataTypes[n].Bcmt;
	      mdata->Ecmt = DataTypes[n].Ecmt;
	      mdata->Bos = DataTypes[n].Bos;
	      mnextstring(mdata);	/* skip the assignment line */
	  }
	  mdata->Eos = DataTypes[n].Eos;

	  ErrorStatus = CreatePixmap(display, visual, d, colormap, mdata,
				     depth, pixmap_return, width_return, 
				     height_return, pixels_return, 
				     npixels_return, colorsymbols, numsymbols,
				     infos);
      } else {
	  ErrorStatus = PixmapFileInvalid;
      }
  } else {
      ErrorStatus = PixmapFileInvalid;
  }
  mclose(mdata);

  return(ErrorStatus);
}
