/*
 * Written by Paul Pomes, University of Illinois, Computing Services Office
 * Copyright (c) 1991 by Paul Pomes and the University of Illinois Board
 * of Trustees.  
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	Illinois, Urbana and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE TRUSTEES AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TRUSTEES OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Email:	Paul-Pomes@uiuc.edu	USMail:	Paul Pomes
 * ICBM:	40 06 47 N / 88 13 35 W		University of Illinois - CSO
 *						1304 West Springfield Avenue
 *						Urbana, Illinois,  61801-2910
 * @(#)$Id: phquery.h,v 1.12 1992/10/07 15:14:57 paul Exp $
 */

/*
 * Configuration parameters.
 *
 * Defining EXPAND_TO will print the list of expanded addresses on an added
 * X-PH-To: header line.  This will also expand names found in /usr/lib/aliases
 * lists.  Leaving it undefined will cause phquery to print only a version
 * line with the name of the host running phquery, e.g.,
 * X-Ph: V3.5@uxc.cso.uiuc.edu .
 */
/*#define		EXPAND_TO	/* Print translated addresses */

/*
 * An address tested as a name is first run through as is.  If no matches
 * are found then any punctuation characters are converted one at a time
 * (leftmost first) to space characters and the lookup is repeated until
 * there are no more punctuation characters.  If WILDNAMES is #define'd,
 * a wildcard char '*' will be appended after each single character name,
 * e.g. p-pomes is tried as "p* pomes".  This has risks as follows:  assume
 * Duncan Lawrie sets his alias to "lawrie".  A query for d-lawrie will
 * fail as a alias lookup but succeed as a name lookup when written as
 * "d* lawrie".  This works until Joe Student sets his alias to "d-lawrie".
 * Whoops.  Still in a non-hostile environment, this function may be more
 * useful than dangerous.
 */
/*#define		WILDNAMES	/* Append '*' to single char names */

/*
 * The types of nameserver queries to make.
 * N.B., Query() assumes that "name" is the last token in this list.
 */
char	*TryList[] =	{ "alias", "callsign", "name", 0 };

/*
 * Permissible fields to return in the case of ambiguous matches or
 * missing email fields.
 */
char	*OKList[] =	{ "alias", "name", "curriculum", "phone",
			  "department", "title", "left_uiuc", 0 };

/*
 * Define if your system lacks the strsep() call.
 */
#undef NEED_STRSEP

/*
 * Domain to append to ph aliases when creating Reply-To: fields.
 * Usually set in Makefile.
 */
#if !defined(DOMAIN) && defined(REPLYTO)
# define	DOMAIN		"uiuc.edu"
#endif	/* !DOMAIN && REPLYTO */

/*
 * Designated server port.  Usually set in Makefile.
 */
#ifndef	QISERVICE
# define	QISERVICE	"ns"
#endif	/* QISERVICE */

/*
 * Sendmail path.  Override if necessary.
 */
#if defined(BSD4_4)
#define		SENDMAIL	"/usr/sbin/sendmail"
#else /* !BSD4_4 */
#define		SENDMAIL	"/usr/lib/sendmail"
#endif /* BSD4_4 */
/* End of configurable parameters. */

/* some handy defines */
#define		CHNULL			('\0')
#define		CPNULL			((char *) NULL)
#define		FILE_NULL		((FILE *) NULL)

/* some handy compare operators */
#define		nequal(s1,s2,n)		(strncasecmp (s1, s2, n) == 0)
#define		equal(s1,s2)		(strcasecmp (s1, s2) == 0)

/* large string size */
#define		MAXSTR			250

/* Bit flags to control printing of informative messages in ErrorReturn() */
#define		NO_MATCH_MSG		0x1
#define		MULTI_MSG		0x2
#define		ABSENT_MSG		0x4
#define		TOO_MANY_MSG		0x8
#define		HARD_MSG		0x10
#define		PHONE_MSG		0x20

/*
** Reply codes:
**	1XX - status
**	2XX - information
**	3XX - additional information or action needed
**	4XX - temporary errors
**	5XX - permanent errors
**	6XX - phquery specific codes
*/
#define LR_PROGRESS	100	/* in progress */
#define LR_ECHO		101	/* echoing cmd */
#define LR_NUMRET	102	/* how many entries are being returned */
#define LR_NONAME	103	/* no hostname found for IP address */

#define LR_OK		200	/* success */
#define LR_RONLY	201	/* database ready in read only mode */

#define LR_MORE		300	/* need more info */
#define LR_LOGIN	301	/* encrypt this string */

#define LR_TEMP		400	/* temporary error */
#define LR_INTERNAL	401	/* database error, possibly temporary */
#define LR_LOCK		402	/* lock not obtained within timeout period */
#define LR_COULDA_BEEN	403	/* login would have been ok but db read only */
#define LR_DOWN		475	/* database unavailable; try again later */

#define LR_ERROR	500	/* hard error; general */
#define	LR_NOMATCH	501	/* no matches to query */
#define LR_TOOMANY	502	/* too many matches to query */
#define LR_AINFO	503	/* may not see that field */
#define LR_ASEARCH	504	/* may not search on that field */
#define LR_ACHANGE	505	/* may not change field */
#define LR_NOTLOG	506	/* must be logged in */
#define LR_FIELD	507	/* field unknown */
#define LR_ABSENT	508	/* field not present in entry */
#define LR_ALIAS	509	/* requested alias is already in use */
#define LR_AENTRY	510	/* may not change entry */
#define LR_ADD		511	/* may not add entries */
#define LR_VALUE	512	/* illegal value */
#define LR_OPTION	513	/* unknown option */
#define LR_UNKNOWN	514	/* unknown command */
#define LR_NOKEY	515	/* no indexed field found in query */
#define LR_AUTH		516	/* no authorization for query */
#define LR_READONLY	517	/* operation failed; database is read-only */
#define LR_LIMIT	518	/* too many entries selected for change */
#define LR_HISTORY	519	/* history substitution failed (obsolete) */
#define LR_XCPU		520	/* too much cpu used */
#define LR_ADDONLY	521	/* addonly option set and change command
				   applied to a field with data */
#define LR_ISCRYPT	522	/* attempt to view encrypted field */
#define LR_NOANSWER	523	/* "answer" was expected but not gotten */
#define LR_BADHELP	524	/* help topics cannot contain slashes */
#define LR_NOEMAIL	525	/* email authentication failed */
#define LR_NOADDR	526	/* host name address not found in DNS */
#define LR_MISMATCH	527	/* host = gethostbyaddr(foo); foo != gethostbyname(host) */
#define LR_OFFCAMPUS	590	/* remote queries not allowed */
#define LR_NOCMD	598	/* no such command */
#define LR_SYNTAX	599	/* syntax error */

#define LR_AMBIGUOUS	600	/* ambiguous or multiple match */

#define		NONE_OF_ABOVE		-1

struct ReplyCodes {
	int	key;
	char	*value;
} Codes[] = {
	LR_PROGRESS,	"Nameserver search in progress",
	LR_ECHO,	"Echoing nameserver cmd",
	LR_NUMRET,	"How many entries are being returned",
	LR_NONAME,	"No hostname found for IP address",
	LR_OK,		"Success",
	LR_RONLY,	"Nameserver database ready in read only mode",
	LR_MORE,	"More info needed to process nameserver query",
	LR_LOGIN,	"Encrypt this string",
	LR_TEMP,	"Temporary nameserver error",
	LR_INTERNAL,	"Nameserver database error, possibly temporary",
	LR_LOCK,	"Nameserver lock not obtained within timeout period",
	LR_COULDA_BEEN,	"Login would have been ok but db read only",
	LR_ERROR,	"Nameserver hard error; general",
	LR_NOMATCH,	"No matches to nameserver query",
	LR_TOOMANY,	"Too many matches found to nameserver query",
	LR_AINFO,	"May not see that nameserver field",
	LR_ASEARCH,	"May not search on that nameserver field",
	LR_ACHANGE,	"May not change that nameserver field",
	LR_NOTLOG,	"Must be logged in to nameserver",
	LR_FIELD,	"Unknown nameserver field",
	LR_ABSENT,	"E-mail field not present in nameserver entry",
	LR_ALIAS,	"Requested nameserver alias is already in use",
	LR_AENTRY,	"May not change nameserver entry",
	LR_ADD,		"May not add nameserver entries",
	LR_VALUE,	"Illegal value",
	LR_OPTION,	"Unknown nameserver option",
	LR_UNKNOWN,	"Unknown nameserver command",
	LR_NOKEY,	"No indexed field found in nameserver query",
	LR_AUTH,	"No authorization for nameserver request",
	LR_READONLY,	"Nameserver operation failed; database is read-only",
	LR_LIMIT,	"Too many nameserver entries selected for change",
	LR_HISTORY,	"History substitution failed (obsolete)",
	LR_XCPU,	"Too much cpu used",
	LR_ADDONLY,	"Addonly option set and change command applied to a field with data",
	LR_ISCRYPT,	"Attempt to view encrypted field",
	LR_NOANSWER,	"\"answer\" was expected but not gotten",
	LR_BADHELP,	"Help topics cannot contain slashes",
	LR_NOEMAIL,	"Email authentication failed",
	LR_NOADDR,	"Host name address not found in DNS",
	LR_MISMATCH,	"Host = gethostbyaddr(foo); foo != gethostbyname(host)",
	LR_OFFCAMPUS,	"Remote queries not allowed",
	LR_NOCMD,	"No such command",
	LR_SYNTAX,	"Syntax error",
	LR_AMBIGUOUS,	"Multiple matches found for nameserver query",
	NONE_OF_ABOVE,	(char *)NULL
};

struct	QI_fields {
	char	*value;
	int	returnOK;
};
typedef struct QI_fields QIF;
#define		QIF_NULL		((QIF *) NULL)

struct	QI_response {
	int	code;
	int	subcode;
	int	field;
	char	*message;
};
typedef struct QI_response QIR;
#define		QIR_NULL		((QIR *) NULL)

struct	NewAddress {
	char	*original;	/* original address */
	char	*new;		/* translated address from qi */
	int	field;		/* lookup field used for match */
	int	code;
	QIR	*QIalt;
};
typedef	struct NewAddress NADD;
#define		NADD_NULL		((NADD *) NULL)
