/*---------------------------------------------------------------------------
Info.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
This code manages the info panel.  Upon initialization, the Info.nib file is
loaded.  The fun things are in the InfoView.m file.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/info.subproj/RCS/Info.m,v 2.0 91/11/18 17:49:23 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	Info.m,v $
Revision 2.0  91/11/18  17:49:23  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Appkit header files */
#import <appkit/Application.h>
#import <appkit/Control.h>
#import <appkit/Panel.h>

/* Application class header files */
#import "Info.h"
#import "GNULicense.h"

@implementation Info

/*---------------------------------------------------------------------------
When the info panel is requested the first time, we must do some work.
-----------------------------------------------------------------------------*/
- init
{
   self = [super init];

   [NXApp loadNibSection:"Info.nib" owner:self withNames:NO];
   [infoPanel setMiniwindowIcon:"app"];

   myGNULicense = nil;

   return self;
}

/*---------------------------------------------------------------------------
Show 'em the info panel.
-----------------------------------------------------------------------------*/
- showInfoPanel:sender
{
   [infoPanel makeKeyAndOrderFront:self];
   return self;
}

/*---------------------------------------------------------------------------
Display the GNU license.
-----------------------------------------------------------------------------*/
- showGNULicense:sender
{
   if (myGNULicense == nil)
      myGNULicense = [[GNULicense alloc] init];

   /*** Not really necessary, but kinda cutesy. */
   if ([sender isKindOf:[Control class]] == YES) {
      [sender setTarget:myGNULicense];
      [sender setAction:@selector (showLicense:)];
   }

   [myGNULicense showLicense:self];
   return self;
}

@end
