/* $Header: uudecode.c,v 4.3.3.1 90/06/20 22:48:21 davison Trn $
**
** $Log:	uudecode.c,v $
** Revision 4.3.3.1  90/06/20  22:48:21  davison
** Initial Trn Release
** 
** Decode one or more uuencoded articles back to binary form.
**
** Trn version created by Wayne Davison.
** Adapted from the nn version by Kim Storm.
** From the Berkeley original, modified by MSD, RDR, JPHD & WLS.
*/

#include "EXTERN.h"
#include "common.h"
#include "INTERN.h"
#include "uudecode.h"

#if 000
export char *decode_header_file = "Decode.Headers";
#endif

#define MAXCHAR 256
#define NORMLEN 60	/* allows for 80 encoded chars per line */

#define SEQMAX 'z'
#define SEQMIN 'a'

static char seqc;
static int first, secnd, check, numl;

static char *target;
static char dest[MAXFILENAME];
static char blank;
static int chtbl[MAXCHAR], cdlen[NORMLEN + 3];
static int state;
static bool Xflag;

#define	NO_ADVANCE		0x10

#define	FIND_BEGIN		0x01
#define	FIND_BEGIN_AFTER_ERROR	0x02
#define	DECODE_TEXT		0x03
#define	SKIP_TRAILING	       (0x04 | NO_ADVANCE)
#define	SKIP_LEADING		0x05
#define	FOUND_END	       (0x06 | NO_ADVANCE)
#define DECODE_ERROR	       (0x07 | NO_ADVANCE)
#define OTHER_ERROR	       (0x08 | NO_ADVANCE)
#define NEW_BEGIN	       (0x09 | NO_ADVANCE)

uud_start(dir)
char *dir;
{
    target = dir;
    uu_out = Nullfp;
    Xflag = FALSE;
    seqc = SEQMAX;
    check = 1;
    first = 1;
    secnd = 0;
    state = FIND_BEGIN;
}

uud_end()
{
    if (uu_out != Nullfp) {
	fclose(uu_out);
	uu_out = Nullfp;
	printf("\n%s INCOMPLETE -- removed\n", dest);
	unlink(dest);
    }
}


uudecode(in)
FILE *in;
{
    int mode, onedone, lens;
    char buff[LBUFLEN];

    numl = onedone = 0;

    if (state == FIND_BEGIN)
	inittbls();

    /*
     * search for header or translation table line.
     */

    while ((state & NO_ADVANCE) || fgets(buff, sizeof buff, in) != Nullch) {
	numl++;

	switch (state) {
	 case NEW_BEGIN:
	    if (uu_out != Nullfp) {
		printf("INCOMPLETE FILE: %s -- removed\n", dest);
		sleep(2);
		fclose(uu_out);
		uu_out = Nullfp;
		Xflag = FALSE;
		unlink(dest);
	    }
	    /* fall thru */

	 case FIND_BEGIN:
	 case FIND_BEGIN_AFTER_ERROR:
	    if (strnEQ(buff, "table ", 6)) {
		gettable(in);
		continue;
	    }

	    if (strnEQ(buff, "begin ", 6)
	     || strnEQ(buff, "Xbegin ", 7)) {
		lens = strlen(buff)-1;
		if (buff[lens] == '\n')
		    buff[lens] = '\0';

		if(sscanf(buff+6,"%o%s", &mode, uu_fname) != 2)
		    continue;

		Xflag = (*buff == 'X');

		if (target != Nullch)
		    sprintf(dest, "%s/%s", target, uu_fname);
		else
		    strcpy(dest, uu_fname);

		if ((uu_out = fopen(dest, "w")) == Nullfp) {
		    printf("Cannot create file: %s\n", dest);
		    goto err;
		}
		chmod(dest, mode);

#if 000
		if (decode_header_file)
		    store_header(ah, in, target, decode_header_file);
#endif

		printf("Decoding: %s\n", uu_fname);
		state = DECODE_TEXT;
	    }
	    continue;

	 case SKIP_LEADING:
	    state = decode_line(buff);
	    continue;

	 case DECODE_TEXT:
	    state = decode_line(buff);
	    onedone = 1;
	    continue;

	 case FOUND_END:
	    fclose(uu_out);
	    uu_out = Nullfp;
	    Xflag = FALSE;
	    state = FIND_BEGIN;
	    printf("Done.\n");
	    continue;

	 case SKIP_TRAILING:
	    printf("(Continued)\n");
	    state = SKIP_LEADING;
	    return 0;

	 case DECODE_ERROR:
	    state = SKIP_TRAILING;
	    continue;

	 case OTHER_ERROR:
	    fclose(uu_out);
	    uu_out = Nullfp;
	    Xflag = FALSE;
	    state = FIND_BEGIN_AFTER_ERROR;
	    goto err;
	}
    }

    if (onedone) {
	if (state == DECODE_TEXT)
	    state = SKIP_LEADING;
	return 0;
    }

    if (state == FIND_BEGIN_AFTER_ERROR)
	return -1;
    printf("Couldn't find anything to decode.\n");

 err:
    sleep(2);
    return -1;
}

/*
 * decode one line, write on uu_out file
 */

static decode_line(buff)
char *buff;
{
    char outl[LBUFLEN];
    register char *bp, *ut;
    register int *trtbl = chtbl;
    register int n;
    register int blen;		/* binary length (from decoded file) */
    register int rlen;		/* calculated input line length */
    register int len;		/* actual input line length */

    if (Xflag) {
	if (*buff == 'X')
	    buff++;
	else
	    *buff = 'x';	/* force a mis-parse of a non-x'ed line */
    }
    len = strlen(buff);
    if (--len < 0)
	return state;

    buff[len] = '\0';

    /*
     * Get the binary line length.
     */
    if ((blen = trtbl[buff[0]]) < 0) {
	if (state == SKIP_LEADING) {
	    if (strnEQ(buff, "begin ", 6))
		return NEW_BEGIN;

	    return SKIP_LEADING;
	}
	/*
	 * end of uuencoded file ?
	 */
	if (strnEQ(buff, "end", 3))
	    return FOUND_END;

	/*
	 * end of current file ? : get next one.
	 */
	if (strnEQ(buff, "include", 7)) {
	    printf("Cannot handle 'include' lines -- unpack with uud\n");
	    return OTHER_ERROR;
	}

	/*
	 * trailing garbage
	 */
	return SKIP_TRAILING;
    }

    rlen = cdlen[blen];
    if (state == SKIP_LEADING && len != rlen && len != rlen+1)
	return SKIP_LEADING;

    /*
     * Is it the empty line before the end line ?
     */
    if (blen == 0)
	return state;

    if (len > rlen + 5)
	return SKIP_TRAILING;

    /*
     * Pad with blanks.
     */
    for (bp = buff + len, n = rlen - len; --n >= 0; )
	*bp++ = blank;

    /*
     * Verify
     */
    for (n = rlen, bp = buff; --n >= 0; bp++)
	if (trtbl[*bp] < 0) {
	    if (state == SKIP_LEADING)
		return SKIP_LEADING;
	    return DECODE_ERROR;
	}

    /*
     * Check for uuencodes that append a 'z' to each line....
     */
    if (check)
	if (secnd) {
	    secnd = 0;
	    if (buff[rlen] == SEQMAX)
		check = 0;
	} else if (first) {
	    first = 0;
	    secnd = 1;
	    if (buff[rlen] != SEQMAX)
		check = 0;
	}

    /*
     * There we check.
     */
    if (check) {
	if (buff[rlen] != seqc) {
	    if (state == SKIP_LEADING)
		return SKIP_LEADING;
	    return DECODE_ERROR;
	}

	if (--seqc < SEQMIN)
	    seqc = SEQMAX;
    }

    /*
     * output a group of 3 bytes (4 input characters).
     * the input chars are pointed to by p, they are to
     * be output to file f. blen is used to tell us not to
     * output all of them at the end of the file.
     */
    ut = outl;
    n = blen;
    bp = &buff[1];
    while (--n >= 0) {
	*(ut++) = trtbl[*bp] << 2 | trtbl[bp[1]] >> 4;
	if (n > 0) {
	    *(ut++) = (trtbl[bp[1]] << 4) | (trtbl[bp[2]] >> 2);
	    n--;
	}
	if (n > 0) {
	    *(ut++) = trtbl[bp[2]] << 6 | trtbl[bp[3]];
	    n--;
	}
	bp += 4;
    }
    if (fwrite(outl, 1, blen, uu_out) <= 0) {
	printf("Error on writing decoded file\n");
	return OTHER_ERROR;
    }

    return DECODE_TEXT;
}



/*
 * Install the table in memory for later use.
 */
static inittbls()
{
    register int i, j;

    /*
     * Set up the default translation table.
     */
    for (i = 0; i < ' '; i++)
	chtbl[i] = -1;
    for (i = ' ', j = 0; i < ' ' + 64; i++, j++)
	chtbl[i] = j;
    for (i = ' ' + 64; i < MAXCHAR; i++)
	chtbl[i] = -1;
    chtbl['`'] = chtbl[' '];	/* common mutation */
    chtbl['~'] = chtbl['^'];	/* another common mutation */
    blank = ' ';
    /*
     * set up the line length table, to avoid computing lotsa * and / ...
     */
    cdlen[0] = 1;
    for (i = 1, j = 5; i <= NORMLEN; i += 3, j += 4)
	cdlen[i] = (cdlen[i + 1] = (cdlen[i + 2] = j));
}

static gettable(in)
FILE *in;
{
    char buff[LBUFLEN];
    register int c, n = 0;
    register char *cpt;

    for (c = 0; c <= MAXCHAR; c++)
	chtbl[c] = -1;

    for (;;) {
	if (fgets(buff, sizeof buff, in) == Nullch) {
	    printf("EOF while in translation table.\n");
	    return -1;
	}
	numl++;
	if (strnEQ(buff, "begin", 5)) {
	    printf("Incomplete translation table.\n");
	    return -1;
	}
	cpt = buff + strlen(buff) - 1;
	*cpt = ' ';
	while (*cpt == ' ') {
	    *cpt = 0;
	    cpt--;
	}
	cpt = buff;
	while (c = *cpt) {
	    if (chtbl[c] != -1) {
		printf("Duplicate char in translation table.\n");
		return -1;
	    }
	    if (n == 0)
		blank = c;
	    chtbl[c] = n++;
	    if (n >= 64)
		return 0;
	    cpt++;
	}
    }
}

