/* $Header: threads.c,v 4.3.3.1 90/07/21 20:33:23 davison Trn $
**
** $Log:	threads.c,v $
** Revision 4.3.3.1  90/07/21  20:33:23  davison
** Initial Trn Release
** 
*/

#include "EXTERN.h"
#include "common.h"
#include "threads.h"

#ifdef USETHREADS

/* Change a newsgroup name into the name of the thread data file.  We
** subsitute any '.'s in the group name into '/'s (unless LONG_THREAD_NAMES
** is defined), prepend the path, and append the '/.thread' (or '.th') on to
** the end.
*/
char *
thread_name( group )
char *group;
{
    register char *ptr;
    static char name_buff[256];
#ifndef LONG_THREAD_NAMES
    char group_buff[256];

    strcpy( group_buff, group);
    ptr = group = group_buff;
    while( (ptr = index( ptr, '.' )) ) {
	*ptr = '/';
    }
#endif
#ifdef SUFFIX
    sprintf( name_buff, "%s/%s%s", THREAD_DIR, group, SUFFIX );
#else
    sprintf( name_buff, "%s/%s", THREAD_DIR, group );
#endif

    return name_buff;
}

/* Determine this machine's byte map for WORDs and LONGs.  A byte map is an
** array of BYTEs (sizeof (WORD) or sizeof (LONG) of them) with the 0th BYTE
** being the byte number of the high-order byte in my <type>, and so forth.
*/
void
mybytemap( map )
BMAP *map;
{
    union {
	BYTE b[sizeof (LONG)];
	WORD w;
	LONG l;
    } u;
    register BYTE *mp;
    register int i, j;

    mp = &map->w[sizeof (WORD)];
    u.w = 1;
    for( i = sizeof (WORD); i > 0; i-- ) {
	for( j = 0; j < sizeof (WORD); j++ ) {
	    if( u.b[j] != 0 ) {
		break;
	    }
	}
	if( j == sizeof (WORD) ) {
	    goto bad_news;
	}
	*--mp = j;
	while (u.b[j] != 0) {
	    u.w <<= 1;
	}
    }

    mp = &map->l[sizeof (LONG)];
    u.l = 1;
    for( i = sizeof (LONG); i > 0; i-- ) {
	for( j = 0; j < sizeof (LONG); j++ ) {
	    if( u.b[j] != 0 ) {
		break;
	    }
	}
	if( j == sizeof (LONG) ) {
	  bad_news:
	    /* trouble -- set both to *something* consistent */
	    for( j = 0; j < sizeof (WORD); j++ ) {
		map->w[j] = j;
	    }
	    for( j = 0; j < sizeof (LONG); j++ ) {
		map->l[j] = j;
	    }
	    return;
	}
	*--mp = j;
	while (u.b[j] != 0) {
	    u.l <<= 1;
	}
    }
}

#endif /* USETHREADS */
