: delay -- this script generates statistics on news propagation delays
:	This TMN version has been modified to no longer need Relay-Version

cd SPOOLDIR
find . -type f ! -name "*.*" \
		-exec sed -n -e '/^[^DPM\n]/d' -e '1,/^$/p' {} \; \
		| awk '
BEGIN{
	t = "Jan 31 Feb 28 Mar 31 Apr 30 May 31 Jun 30 Jul 31 Aug 31 Sep 30 Oct 31 Nov 30 Dec 31"
	split(t,x)
	n = 0;
	for(i=1;i<24;i+=2) {
		month[x[i]] = (i+1)/2
		days[(i+1)/2] = n
		n += x[i+1]
	}
}

/^Date: /{
	if (NF == 7 ){
		t = $6
		x[1] = $3
		x[2] = $4
		x[3] = $5
	} else if (NF == 5 && split($3,x,"-") == 3) {
		t = $4
	} else if (NF == 4 && split($2,x,"-") == 3) {
		t = $3
	}else if (NF == 6) {
		t = $5
		x[1] = $2
		x[2] = $3
		x[3] = $4
	}else{
		print "Bad date",messageid, $0
		next
	}
	sent = x[1] + days[month[x[2]]] + (x[3]-80)*365
	if (x[3]%4 == 0 && month[x[2]] > 2)
		sent++
	split(t,x,":")
	sent *= 60*24
	sent += x[1] * 60 + x[2]
}
/^Date-Received: /{
	if (NF == 7 ){
		t = $6
		x[1] = $3
		x[2] = $4
		x[3] = $5
	} else if (NF == 5 && split($3,x,"-") == 3) {
		t = $4
	} else if (NF == 4 && split($2,x,"-") == 3) {
		t = $3
	}else if (NF == 6) {
		t = $5
		x[1] = $2
		x[2] = $3
		x[3] = $4
	}else{
		print "Bad date",messageid, $0
		continue
	}
	rec = x[3]*10000 +  month[x[2]]* 100 + x[1]
	if (rec > today)
		today = rec
	rec = x[1] + days[month[x[2]]] + (x[3]-80)*365
	if (x[3]%4 == 0 && month[x[2]] > 2)
		rec++
	split(t,x,":")
	rec *= 60*24
	rec += x[1] * 60 + x[2] +1.44
}
/^Message-ID: /{messageid = $2}
/^Path: /{
	n = split($2,x,"!")
	if( n > 2)
		feed = x[2]
	else
		feed = x[1]
}
/^$/{
	n = int((rec - sent)/(60*24)+0.999)
	if( rec > 0 ) {
		if ( n >= 0) {
			adelay[n]++
			if( n > amaxdelay)
				amaxdelay = n
		} else {
			adelay[-1]++
			print "Time Warp", messageid
		}
		totdelay++
		feedsite[feed]++
	}
	rec = sent = 0
}
END {
	n = int((rec - sent)/(60*24)+0.999)
	if( rec > 0 ) {
		if ( n >= 0) {
			adelay[n]++
			if( n > amaxdelay)
				amaxdelay = n
		} else {
			adelay[-1]++
			print "Time Warp", messageid
		}
		totdelay++
		feedsite[feed]++
	}
	i = 0
	count = 0
	printf("\n\tPropagation Delay\n")
	printf("\n\t     No. of   Cumulative\n")
	printf("\tDays Articles Percent\n")
	if (adelay[-1] > 0) {
		printf("\t <0%8d%7d%% (Time Warp)\n",adelay[-1],0)
		count += adelay[-1]
	}
	while (i <= amaxdelay) {
		count += adelay[i]
		if( adelay[i] != 0 )
			printf("\t%3d%8d%7d%%\n",i,adelay[i],(count*100)/totdelay)
		i++
	}

	n = 0
	for (i in feedsite)
		ptr[++n] = i

	j = 1
	while (j < n){
		if  (feedsite[ptr[j]] < feedsite[ptr[j+1]]){
			temp = ptr[j]
			ptr[j] = ptr[j+1]
			ptr[j+1] = temp
			if( j > 1) {
				j--
				continue
			}
		}
		j++
	}
	printf("\n\tDistribution of news feeds\n")
	printf("\t   Count Percent   Site\n")
	j = 0
	while (++j <= n){
		i =feedsite[ptr[j]]
		printf("\t%8d%7d%%   %s\n",i,(i*100)/totdelay,ptr[j]);
	}
}'

# delay ends here
