/*
** 	@(#)rkive.h	2.2 2/23/91
**
**	This is the rkive source configuration header file. 
**	Please examine and change to suite your own site's needs..
**
*/

/*
** The default owner, group and modes of the archived files
** need to be stated below. The values are only used if the
** appropriate values are not in the configuration file.
*/ 

#define OWNER    0
#define GROUP    3
#define MODES    0444
#define DIR_MODE 0755         /* directory creation modes */

/* 
** If you have a smart mailer that supports a "-s subject" command
** and you wish to have the subject line added when archived mail
** is sent, define SUBJECT_LINE. 
*/

#define SUBJECT_LINE 

#ifdef SUBJECT_LINE
#define MAIL        "/usr/ucb/Mail"	/* mail program to use */
# ifdef NOTDEF
#  define MAIL        "/usr/local/bin/elm"
#  define MAIL        "/usr/bin/mailx" 	 /* mail program to use */
#  define MAIL        "/usr/local/bin/mush"
# endif /*NOTDEF*/
#else
#define MAIL        "/bin/mail"	 /* mail program to use */
#endif

/*
** The PROBLEMS_DIR is the default directory to use in the event 
** problems are encountered such as duplicate article names and 
** the execution flags do not specify overwriting. 
**
** The new, inbound article is stored in the PROBLEMS_DIR in the 
** problems_dir/newsgroup/volume/filename so that the administrator 
** can review and fix the problem whenever time becomes available...
**
** The PROBLEMS_DIR define is used only if the administrator has not 
** specified the PROBLEMS path variable inside of the LOCATION 
** (config) file.
*/

#define PROBLEMS_DIR "/usenet/problems"  

/* 
** Home directory for news    
*/

#define SPOOLDIR     "/usr/spool/news"   

/* 
** Location of the default rkive configuration file.
*/

#define LOCATION     "/usr/local/lib/rkive/rkive.cf"  

/*
** Defines to control the handling of repostings.
**
** ADD_REPOST_SUFFIX && REPOST_SUFFIX
**
**     If ADD_REPOST_SUFFIX is defined, all reposts will have the 
**     string specified in REPOST_SUFFIX appended to the archive
**     filename so that a repost of elm/part07 would appear in
**     the archive as elm/part07-repost prior to any compression.
**
**     CAUTION: This should *not* be used on a filesystem with
**		14 character file name limits. If you are going
**		to be making your archive available to the general
**		community do *not* use this. The portability of
**		filenames is greatly reduced. This has been added
**		with much hesitation. The rational was that there
**		was no reason to punish/limit the functionality
**		just because of limitations of a specific "brand"
**		of unix and since that "brand" was correcting its
**		"error" in the future, why not put it in now ?
**		This is not a configuration item on a per newsgroup
**		basis. It might be useful for Historical archiving
**		using only Volume/Issue archiving with no COMPRESSION.
**
** MV_ORIGINAL
**     The original article is placed into a "original" directory in 
**     the problems directory (if duplicated). The inbound reposted
**     article is placed into the archive in the correct position.
**
** No Reposting Defines specified:
**    The inbound article would be placed into the archive in the 
**    correct position only if the initial article is not in the archive.
**    Otherwise the reposted article is placed in the problems directory 
**    as a normal duplicate article is now.
*/

/* #define ADD_REPOST_SUFFIX */
#define MV_ORIGINAL 

#ifdef ADD_REPOST_SUFFIX 
#define REPOST_SUFFIX  "-repost" 
#endif

/* 
** If you wish your volume directories to be Volume, VOL, vOLuMe
** or any other such nonsense, change the VOLUME define below.
*/

#define VOLUME       "volume"

/*
** Very small change to construct change the volume directory names 
** from "volume1" to "volume01". In this manner all of the archive
** volume directories appear in lexical order instead of jumbled 
** together in directory listings. This option was "requested"...
*/

/*#define ZEROFILL*/

/* 
** If you wish to have the headers "trimmed" when the file is archived,
** assure that REDUCE_HEADERS is defined. Currenlty all header lines that
** are not either;
**    From:, Newsgroups:, Subject:, Message-ID: Approved:, and Date:
** will be removed. See news_arc.c if you wish to add or subtract header
** lines to keep. This can produce a savings of between 200 to 500 bytes
** per archived article.
*/

#define REDUCE_HEADERS 

/* 
** The following define specifies a default format for generating
** index file records in the event that there is no index format
** specified for either the newsgroup or for the global default.
** See article.1 for a discussion of the different types of selection
** characters available for use in the format specifications.
*/

#define DEFAULT_INDEX_FORMAT       "%B\t%S"

/* 
** The following define specifies a default format for generating
** log file records in the event that there is no log format
** specified for either the newsgroup or for the global default.
*/
#define DEFAULT_LOG_FORMAT         "%O\t%T"

/*
** The size of the group array. If you are archiving the world
** you might need to bump this up...
*/

#define NUM_NEWSGROUPS  32

/**********************************************************************
*******************  NO CHANGES REQUIRED PAST HERE  *******************
**********************************************************************/

/*
** check to assure repost defines are in order...
*/

#if defined(ADD_REPOST_SUFFIX) + defined(MV_ORIGINAL) > 1
#include "ERROR - Can only specify a maximum of one way to handle reposts!"
#endif

#include <dirent.h>

int fprintf();

/*
** Standard stuff
*/

#ifndef TRUE
#define TRUE   1
#endif

#ifndef FALSE
#define FALSE  0
#endif

/*
** The MAXNAMLEN define is here for systems such as SCO
** that have MAXNAMLEN in other then dirent.h
**         Samuel Lam <uunet!van-bc!skl> 
*/
#ifndef MAXNAMLEN
#define MAXNAMLEN  255
#endif 

/*
** retrieve_article() return values
*/
#define ERROR_ENCOUNTERED -1
#define DONE 0
#define RETRIEVED 1

/*
** retrieve_article() from defines
*/
#define FROM_DISK       0
#define FROM_NAME       1
#define FROM_BATCHFILE  2
#ifdef NNTP
# define FROM_NNTP      3
#endif /*NNTP*/

/*
** archive type defines 
**
** These defines are used to determine which type of archiving 
** methods the administrator has requested for the newsgroup.
**
*/

#define ARCHIVE_NAME     0	/* Archive as "elm/part03"  */
                                /* and moderator info also. */
#define VOLUME_ISSUE     1	/* Archive as "v16i003"     */
#define ARTICLE_NUMBER   2	/* Archive with same name   */
				/* as the file to archive   */
#define CHRONOLOGICAL    3	/* Archive as "890619002"   */
                                /* or YYMMDDIII format      */
#define COMP_ARCHIVES    4	/* Archive for comp.archives*/
#define EXTERNAL_COMMAND 5	/* Archive by piping the    */
                                /* articles to the external */
                                /* command specified int the*/
                                /* rkive.cf file.           */
#define ONLY_ARCHIVE_NAME 6	/* Archive as "elm/part03"  */

#define MAXMATCHLEN   10000   /* Length for Match-expression. */


/*
** patch handling type defines 
**
** These defines are used to determine which type of 
** method the administrator has requested for the the
** handling of patches received in the newsgroup.
**
*/

#define HISTORICAL   0    	/* Archive as normally done.        */
#define PACKAGE      1    	/* Archive patches in the directory */
                                /* containing the initial posting.  */

struct group_archive {
    int owner;                  /* owner id of the archive files     */
    int group;                  /* group id of the archive files     */
    int modes;                  /* modes of the stored archive files */
    int type;                   /* Type of archiving to be used.     */
				/*        0 = Archive-Name           */
                                /*        1 = Volume-Issue           */
                                /*        2 = Article-Number         */
                                /*        3 = Chronological          */
                                /*        4 = Comp-Archives          */
                                /*        5 = External-Command       */
    int patch_type;             /* Method of handling patches.       */
                                /*        0 = Historical             */
                                /*        1 = Package                */
    char ng_name[MAXNAMLEN];    /* Newsgroup to be archived.         */
    char ng_path[MAXNAMLEN];    /* Path to archive's base directory. */
    char location[MAXNAMLEN];	/* Path to archive's base directory. */
    char arc_done[MAXNAMLEN];	/* Archive's .archived already file  */
    char mail_list[BUFSIZ];	/* List of users to mail when new    */
				/* members are added to the archive. */
    char logfile[MAXNAMLEN];	/* Path to archive specific log file */
    char index[MAXNAMLEN]; 	/* Path to archive specific index.   */
    char patchlog[MAXNAMLEN];	/* Path to archive's patches log.    */
    char logformat[BUFSIZ];	/* Format of the logfile entry.      */
    char indformat[BUFSIZ];	/* Format of the index entry.        */
    char compress[MAXNAMLEN];	/* Command line to use to compress   */
				/* new archive members, optional.    */
    char arch_command[MAXNAMLEN]; /* Command line to use to archive  */
                              	/* the articles in the newsgroup.    */
    char checkhash[MAXNAMLEN];	/* Command line to use to test       */
				/* articles for transit damage.      */
    char match[MAXMATCHLEN];    /* Match-expression                  */
#ifdef NNTP
    char nntp[MAXNAMLEN];	/* Name of system with nntp server   */
#endif /*NNTP*/
};
