/*
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise 
** use any part of this package as long as you do not try to make 
** money from it or pretend that you wrote it.  This copyright 
** notice must be maintained in any copy made.
**
*/

#if !defined(lint) && !defined(SABER)
static char SID[] = "@(#)record_arc.c	2.2 5/9/91";
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "cfg.h"

static char work[BUFSIZ];
static int len;
static FILE *archived_fp;

int fclose();
int sscanf();
int strlen();
int strncmp();
FILE *fopen();
FILE *efopen();

extern int retrieve;
extern int verbose;
extern int test;
extern struct group_archive *newsgrp;

/*
** ********************************************************************
** This file contains functions to maintain the .archived file in the
** newsgroup's archive BASEDIR directory. The .archived file is used to 
** assure that articles are not archived over and over and that the 
** administrator does not need to wait until the articles have
** expired before they are added to the archive. 
** The .archived file stores a list of message-ids and archived paths
** of articles that have been added to the archives already. 
** *******************************************************************
*/

/*
** get_archived_rec:
**
** get_archived_rec(message_id) char *message_id; { return(work); }
**
** get_archived_rec is used to determine if the message_id
** passed to it has been archived. If its message_id is found
** in the .archived file, it has been previously archived
** and its archive information record is  returned to the
** caling routine. Else it returns NULL.
*/

char *get_archived_rec(message_id)
    char *message_id;
{
    /*
    ** If the .archived file is missing, it must be
    ** the first time that it is to be archived.
    */
    if ((archived_fp = fopen(newsgrp->arc_done,"r")) == NULL) 
	return(NULL);

    len = strlen(message_id);
 
    while (fgets(work, sizeof work, archived_fp) != NULL) {
        if (*work == '#')
            continue;
        if ((strncmp(work,message_id,len) == 0) && (work[len] == ' ')) {
            (void) fclose(archived_fp);
            *(work+(strlen(work)-1)) = '\0';
            return(work);
        }
    }
    (void) fclose(archived_fp);
    return(NULL);
}

/*
** needs_to_be_archived:
**
** int needs_to_be_archived(message_id) char *message_id; { return(0); }
**
** This function is used to determine if the message-id
** passed to it requires archiving. If the message-id is
** found in the .archived file, it has been previously
** archived and does not need to be now. If it is not
** found in the .archived file, it needs to be archived.
*/

int needs_to_be_archived(message_id)
    char *message_id;
{
    if (get_archived_rec(message_id) == NULL)
	return(1);
#ifdef NNTP
    if (verbose && retrieve == FROM_NNTP) 
        (void) fprintf(logfp, "Skipping, %s, previously archived.\n", message_id);
#endif /*NNTP*/
    return(0);
}

/*
** write_archived:
**
** write_archived(message_id, path) char *message_id, path; {}
**
** This function is used to write a message_id and its archived location
** to the .archived file in the newsgroup's archive BASEDIR
** directory since we do not want it rearchived tomorrow.
*/

void write_archived(message_id, path)
    char *message_id;
    char *path;
{
    FILE *fp;
    struct stat sb;

    /* 
    ** If in test mode no actual operations are 
    ** to be done...
    */
    if (test)
        return;

    if ((stat(newsgrp->arc_done ,&sb) != 0)) 
        if (mkparents(newsgrp->arc_done) == -1)
            return;          /* unable to build parent directories */

    /*
    ** open the file and append the record
    */

    fp = efopen(newsgrp->arc_done,"a+");
    (void) fprintf(fp,"%s %s\n",message_id, path);
    (void) fclose(fp);
    return;
}
