/*
 * string operations
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include "news.h"

/*
 * Return strsave() of the first word in "tokens".
 * Words are delimited by spaces.
 */
char *
first(tokens)
char *tokens;
{
	return strsvto(tokens, ' ');
}

/*
 * Turn a newsgroup name into a file name, in place.
 */
void
mkfilenm(ng)
register char *ng;
{
	for (; *ng != '\0'; ng++)
		if (*ng == NGDELIM)
			*ng = FNDELIM;
}

char *
trim(s)					/* trim trailing newline */
char *s;
{
	register char *nl;

/*	STRRCHR(s, '\n', nl);	*/
	nl = strrchr(s, '\n');
	if (nl != NULL)
		*nl = '\0';
	return s;
}

char *
skipsp(s)				/* skip any whitespace at *s */
register char *s;
{
	while (iswhite(*s))
		s++;
	return s;
}

char *
strsvto(s, c)				/* save s up to (but excluding) c */
char *s;
int c;
{
	register char *endp, *copy;

	STRCHR(s, c, endp);		/* find interesting part's end of s */
	if (endp != NULL)
		*endp = '\0';		/* restored below */
	copy = strsave(s);		/* copy interesting substring of s */
    	if (endp != NULL)
	    	*endp = c;
	return copy;
}

int
charcount(s, c)			/* how many c's in s? */
register char *s;
register int c;
{
	register int count = 0;

	/*
	 * this is arguably cleaner, but slower:
	 * for (; (s = strchr(s, c)) != NULL; s = (s == NULL? NULL: s+1))
	 *	++count;
	 */
	while (*s != '\0')
		if (*s++ == c)
			++count;
	return count;
}

char *
nullify(s)				/* return s or "" if NULL */
register char *s;
{
	if (s == NULL)
		return "";
	else
		return s;
}
