#ifdef	RCSIDENT
static char rcsid[]="$Header: prindex.c,v 1.2 87/02/05 19:54:02 notes Exp $";
#endif	RCSIDENT

/*
 *	prindex.c
 */

#include "parms.h"
#include "structs.h"
#include <fcntl.h>

/* #define DEBUG	/* */

extern int   errno;
extern char *sys_errlist[];

int ignsigs = 0;

main(argc, argv)
char **argv;
{
	int i;
	struct nfile *np;
	struct io_f   io;
	DBM  *db;
	datum key;
	datum d;
	char fn[BUFLEN];	/* filename for msg-ID database */
	int  returnval = GOOD;	/* arg for exit() */
	struct note_f note;
	struct resp_f rrec;
	int  notenum;
	int  respnum;
	int  rrecnum;
	int  roffset;

	initenv();

	if (argc == 1) {
	    usage(argv[0]);
	    exit (BAD);
	}

	/* MAYBE ALLOW DIRECTOR'S TOO? */
	if (globuid != notesuid) {
		fprintf(stderr, "Sorry, only notes 'owner' can rebuild the Message-ID index\n");
		exit(BAD);
	}


	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {

			case 'f': 		/* process a file */
				readrc(argv[++i]);
				break;

			default: 
				fprintf(stderr, "Bad switch: %c\n", argv[i][1]);
				usage(argv[0]);
				exit(BAD);
			}
		} else {
			expand(argv[i]);
		}
	}

	for (np = nfile; np; np = np->n_next) {
	  if (np->n_lookat == 0)
	    continue;
		
	  sprintf(fn, "%s/%s/%s", spooldir, mapnfname(np->n_name), INDEXM);

	  /* Create an empty index database */
	  db = dbm_open(fn, O_RDWR, 0);
	  if (db == NULL)
	    {
	      fprintf(stderr, "%s: dbm_open failed for Msg-ID database, filename= \"%s\", errno= %d (%s)\n",
		      argv[0], fn, errno, sys_errlist[errno]);
	      returnval = BAD;
	      continue;		/* see if the next one breaks, too */
	    }

	  /* Should fetch and print version right here */

	  for( key = dbm_firstkey(db) ; key.dptr != NULL ; key = dbm_nextkey(db, key) )
	    {
	      d = dbm_fetch(db, key);
	      printf("%s\t%s\n", key.dptr, d.dptr);
	    }	  

	  dbm_close(db);
	}

	exit(GOOD);
}

usage (invokedas)
char *invokedas;
{
	fprintf(stderr,
	    "Usage: %s [-f file] topic1 [topic2 ...]\n",
	    invokedas);
}


  
