/*
 *		COPYRIGHT (c) HEWLETT-PACKARD COMPANY, 1984
 *
 *	Permission is granted for unlimited modification, use, and
 *	distribution except that this software may not be sold for
 *	profit.  No warranty is implied or expressed.
 *
 *Author:
 *	Paul Bame, HEWLETT-PACKARD LOGIC SYSTEMS DIVISION - Colorado Springs
 *	{ ihnp4!hpfcla | hplabs | harpo!hp-pcd }!hp-lsd!paul
 */

#ifdef SYSBOOLEAN
#   include <boolean.h>		/* Installed where everyone can get to it */
#else
#   include "boolean.h"		/* OK, use the local one */
#endif SYSBOOLEAN

#define INDENT(x)	{int i; for(i = 0 ; i < x ; i++) putchar('\t');}

extern boolean _wildmatch();
extern boolean tailmatch();

boolean wildmatch(pattern,subject)
char *pattern;
char *subject;
/*
 *	string pattern, is matched against string, 'subject' and TRUE is returned
 *	if the match is successful.  'pattern' may contain the shell metas, *, and
 *	? and the semantics are the same.  ? and * may be escaped with \
 *
 *	The dodge with the names is for debugging.
 */
{
	return( _wildmatch( pattern, subject, 0 ) );
}

static
boolean
_wildmatch(pattern,subject,depth)
register char *pattern;
register char *subject;
int depth;
{
	int c;

#ifdef DEBUG
	INDENT(depth);
	printf("_wildmatch(%s,%s)\n",pattern,subject);
#endif

	while( (c = *pattern++) != '\0' )
	{
		switch( c )
		{
		case '*':
			return(tailmatch( pattern, subject, depth+1 ));

		case '?':
			break;

		case '\\':
			c = *pattern++;
			/** FALL THROUGH - WATCH THIS - IT'S A TAD TRICKY **/

		default:
			if( c != *subject )
			{
#ifdef DEBUG
				INDENT(depth);
				printf("returning FALSE\n");
#endif
				return(FALSE);
			}
		}
		subject++;
	}

	/* if pattern subject expired before target */
	if( *subject != '\0' )
	{
#ifdef DEBUG
		INDENT(depth);
		printf("returning FALSE\n");
#endif
		return(FALSE);
	}

#ifdef DEBUG
	INDENT(depth);
	printf("returning TRUE\n");
#endif
	return(TRUE);
}

static
boolean
tailmatch(pattern,subject,depth)
register char *pattern;
register char *subject;
int depth;
/*
 *	This is similar to _wildmatch and is used by it.  It is used after a
 *	'*' has been encounterd in the pattern to try to re-sync the match.
 */
{
	char c;

#ifdef DEBUG
	INDENT(depth);
	printf("tailmatch(%s,%s) \n",pattern,subject);
#endif
	/* if pattern string is exhausted, anything is a tail match */
	if( *pattern == '\0' )
	{
#ifdef DEBUG
	INDENT(depth);
	printf("returning TRUE\n");
#endif
		return(TRUE);
	}

	switch(*pattern)
	{
	case '?':
		return( tailmatch(pattern+1,subject+1,depth+1));

	case '*':
		return( tailmatch(pattern+1,subject,depth+1));

	case '\\':
		pattern++;
		/* FALL THROUGH */

	default:
		while( (c = *subject) != '\0' )
		{
			if( c == *pattern )
			{
				/* possible match */
				if( _wildmatch( pattern+1, subject+1, depth+1 ) )
				{
#ifdef DEBUG
					INDENT(depth);
					printf("returning TRUE\n");
#endif
					return(TRUE);
				}
			}
			subject++;
		}
	}

#ifdef DEBUG
	INDENT(depth);
	printf("returning FALSE\n");
#endif
	return(FALSE);
}

#ifdef DEBUG
#define MAIN main
MAIN()
{
	char pattern[50], subject[50];

	while(1)
	{
		scanf("%s %s",pattern,subject);
		printf("MATCH is %s\n",
			( (wildmatch(pattern,subject))?"TRUE":"FALSE"));
	}
}
#endif
