#ifdef	RCSIDENT
static char rcsid[]="$Header: /g1/users/staff/gore/exp/notes/src/RCS/notes.c,v 2.0 89/04/16 00:28:09 gore Exp $";
#endif	RCSIDENT

/*
 *	this  main program will take in a notefile name, and
 *	then proceed to handle all of the processing for it. This includes
 *	calling all of the appropriate routines. It should stay in the 
 *	package pretty much as is. It may not be the master routine, but
 *	it will be the chief 'driver' while within a particular note.
 *
 *	Original author: Rob Kolstad	Winter, 1980.
 *	Modifications:	Ray Essick	June, 1981.
 *	Modified more:	Ray Essick	May, 1982.
 *	Modified even more:  Rick L Spickelmier   UCB  1982
 *	Keep going:  Lou Salkind   	  NYU  1983
 *	Oh, let's face it.  Everybody and their grandmother
 *	have modified this file.
 */

#include "parms.h"
#include "structs.h"
#include "version.h"
#include <sys/stat.h>
#include "dumpmsg.h"

int terse = 0;
int concise_quotes = 0;
int jump_over_xposts = 0;
dumpfmt_t dmp_format;

char *rindex();

main(argc, argv)
	int argc;
	char  **argv;
{
	int i;
	int autoseq = 0;
	int notesargs = 0;
	char *p;
	char cmdline[CMDLEN];
	char obuf[BUFSIZ];
	char seqfilename[WDLEN];
	struct nfile *np;
	char *sequencer = NULL;

	initenv();
	setbuf(stdout, obuf);		/* XXX */

	/* find out if we are autoseq or not */
	if (p = rindex(argv[0], '/'))
		p++;
	else
		p = argv[0];
	if (strcmp(p, AUTOSEQ) == 0)
		autoseq++;

	printf ("%s: %s\n", p, NEWS_VERSION);

	if (autoseq)
	    setseq(NORMSEQ);

	/*
	 * COMMAND LINE DECODER
	 */
	for (i = 1; i < argc; i++)
	if (pending) {				/* value for last option */
	        expand(argv[i]);
	} else if (argv[i][0] == '-') {		/* option */
		switch (argv[i][1]) {
		case 's': 			/* -S-equencer */
		case 'x': 			/* e-X-tended sequencer */
		case 'i': 			/* -I-ndexing sequencer */
		case 'n': 			/* -N-o sequencer */
		case 't':
		case 'c':
		case 'j':
		case 'd':
			expand(argv[i]);
			break;

		case 'T': 			/* overiding tty type */
			if (++i < argc)
				myterm = argv[i];
			break;

		case 'f': 			/* -f file option */
			if (++i < argc)
				notesrc = argv[i];
			break;

		case 'r': 			/* Reply-To: address */
			if (++i < argc) {
			    replyto_address = argv[i];
			} else {
			    fprintf(stderr,
				    "-r needs an address after it\n");
			    exit(BAD);
			}
			break;

		case 'a': 			/* alternate sequencer */
			if (++i == argc)	/* supplied name? */
			  {
			  fprintf (stderr, "-a requires a name\n");
			  exit (BAD);
			  }
			else
			  {
			  if (argv[i][0] == '/')
			    sequencer = strsave(argv[i]);
			  else
			    {
			    sprintf(cmdline, "%s/%s", myhome? myhome : ".",
				    argv[i]);
			    sequencer = strsave(cmdline);
			    }
			  }
			break;
#ifdef notdef
/* from 1.7 -- not finished, doesn't work yet */
		case 'o': 			/* zero date */
			if (++i == argc)	/* give a date? */
			  {
			    fprintf (stderr, "-o requires a date\n");
			    exit (BAD);
			  }
			else
			  {
			  time_t ztime,now;
			  
			  ztime = getdate (argv[i], 0);
			  if (ztime == -1)
			    {
			    fprintf (stderr, "Unable to parse time `%s'\n",
				     argv[i]);
			    exit (BAD);
			    }
			  now = time((long*)0);
			  if (ztime > now)
			    {
			    fprintf (stderr, "Parsed date (%s) is in the future\n",
				     argv[i]);
			    exit (BAD);
			    }
			  }
			/* everything OK */
			Basetime = ztime;	/* store it */
			setseq (USERSEQ);	/* readonly */
			break;
#endif notdef
		default: 
			printf("Bad switch `%c'\n", argv[i][1]);
			usage (argv[0]);
			cleanup(BAD);
		}
	} else {
		/* PROCESS FILE ARGUMENT */
		expand(argv[i]);
		notesargs++;
	}

	if (myterm == NULL) {
		printf("Please set your TERM environmental variable\n");
		printf("or specify [-T ttytype] as a command line option\n");
		exit(BAD);
	}

	if (cursget(myterm) < 0) {
		printf("Unknown terminal type: %s\n", myterm);
		exit(BAD);
	}

	if (notesrc) {
		if (readrc(notesrc)) {
			perror(notesrc);
			cleanup(BAD);
		}
	} else if (notesargs == 0) {
		sprintf(cmdline, "%s/%s", myhome? myhome : ".", NOTESRC);
		notesrc = strsave(cmdline);
		if (readrc(notesrc) < 0) {
			/*
			 * the user didn't specify a notesfile on the command
			 * and doesn't have a default notesrc file.  Error.
			 */
			sprintf(cmdline, "%s/help/%s", libdir, AVAILHLP);
			dounix(pager, cmdline, NOSTR);
			cleanup(BAD);
		}
	}

	if (sequencer == NULL)
	  {
	  sprintf(cmdline, "%s/%s", myhome? myhome : ".", NOTESEQ);
	  sequencer = strsave(cmdline);
	  }
	if (doseqread())
		readseq(sequencer, 0);

	if (setjmp(jenv))
		goto out;
	catchem();
	ttystrt();				/* CBREAK mode */

	/*
	 * Arguments all processed.  Read the notesfiles.
	 */
	for (np = nfile; np; np = np->n_next) {
		if (np->n_lookat == 0)
			continue;
		concise_quotes = np->n_concise;
		dmp_format = np->n_dumpfmt;
		jump_over_xposts = np->n_jumpxpost;
		i = control(np->n_name, np->n_seqtyp, np->n_when, sequencer);
		if (i == QUITFAST || i == QUITUPD)
			break;
		switch (i) {
		case QUITNEX:
			printf("No such notesfile `%s'\n", np->n_name);
			break;
		case -1:
			prompt("%s...", np->n_name);
			fflush(stdout);
			break;
		case QUITBAD:
		default:
			break;
		}
	}
out:
	if (doseqwrite()) {
		ignsigs++;
		prompt("Writing sequencer...");
		fflush(stdout);
		writeseq(sequencer);
		ignsigs--;
	}
	cleanup(GOOD);
}

cleanup(Status)
{
	cursend();
	ttystop();				/* back to normal mode */
	exit(Status);
}

usage (invokedas)
char *invokedas;
{
    printf ("Usage: %s [-f file] [-s|x|i|n] [-cjt] [-T termtype]\n",invokedas);
    printf ("\t\t[-r reply-to-address] [-d how-to-save-to-disk]\n");
    printf ("\t-f file overrides your .notesrc file\n");
    printf ("\t-a file overrides your .nfseq file\n");
    printf ("\t-s uses the sequencer\n\t-x uses the extended sequencer\n");
    printf ("\t-i uses the index sequencer\n\t-n uses NO sequencer\n");
    printf ("\t-j toggles jumping over crossposted articles already read\n");
    printf ("\t-t turns on \"terse\" mode\n");
    printf ("\t-T overrides TERM variable\n");
    printf("\t-c toggles use of more concise reference headers in replies\n");
    printf(
	  "\t-r address sets the \"Reply-To:\" address for messages you post\n"
	  );
    printf("\t-d sets the note saving format to:\n");
    explain_dump_formats(stdout);
}
