/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/nfprint.c,v 1.1 89/01/28 22:34:55 gore Exp $ */

/*
 *	nfprint - print out the contents of a notefile.
 *
 *	this program produces line printable output for the 
 *	notefile specified. Included is a table of contents
 *	detailing where the notes are.
 *
 *	Call:
 *		nfprint [-lnn] notefile list > output
 *
 *	list is an orders list on notenumbers.
 *
 *	Original Coding:	Ray Essick	January 1982
 */

#include "parms.h"
#include "structs.h"

#define	PLENGTH	66			/* length of a page */

int     length;				/* length of a page */
int     left;				/* lines left on the current page */
int     page;				/* which page we are on */

main(argc, argv)
char  **argv;
{
	struct io_f io;
	FILE *toc;		/* table of contents scratch file */
	FILE * lprfile;
	FILE * popen ();
	char    cmdline[CMDLEN];
	struct note_f   note;
	register int    i;
	char    dfltrange[10];		/* hold default list */
	char *bufptr;
	int  start, end;
	int     singlepage;
	char    fn[WDLEN];			/* file name */
	int     argp;

	initenv();

	if (argc == 1) {			/* tell him how */
		usage (argv[0]);
		exit (BAD);
	}

	page = 1;
	singlepage = 0;			/* no page break between notes */
	length = PLENGTH;
	argp = 1;				/* arg parsing */
	while (argv[argp][0] == '-') {
		switch (argv[argp][1]) {
		case 'l': 			/* page length */
			length = atoi (&argv[argp][2]);
			break;

		case 'p': 		/* start all notes on fresh page */
			singlepage++;
			break;

		default: 
			fprintf (stderr, "Bad switch `%c'\n", argv[argp][1]);
			usage (argv[0]);
			exit (BAD);
		}

		argp++;				/* jump to next one */
	}
	if (init (&io, argv[argp]) < 0) {	/* get the notesfile */
		exit (NONF);
	}
	if (allow (&io, READOK) == 0) {
		fprintf(stderr, "You are not allowed to read %s\n", argv[argp]);
		exit(BAD);
	}

	sprintf(fn, "%s/nfXXXXXX", TMPDIR);	/* build toc file */
	mktemp(fn);
	x ((toc = fopen(fn, "w")) == NULL,
	    "nfprint: can't open scratch file \"%s\" for writing", fn);

	sprintf (cmdline, "pr -l%d -h '%s'", length, io.descr.d_title);
	x ((lprfile = popen(cmdline, "w")) == NULL,
	    "nfprint: can't open a pipe to \"pr\"");


	length -= 10;			/* pr uses 5 & 5 for header/footer */
	left = length;			/* empty page */
	if (argp == (argc - 1)) {		/* last arg ... */
		sprintf(dfltrange, "%d-%d", 1, io.descr.d_nnote);
		argv[argp--] = dfltrange;		/* set up as an arg */
	}
	argp++;					/* advance to next arg */
	for (; argp < argc; argp++) {
		bufptr = argv[argp];
		while (listget(&bufptr, &start, &end)) {
			if (start > end) {
				continue;		/* wrong order */
			}
			if (start > io.descr.d_nnote) {
				continue;		/* too far out */
			}
			if (start < 1) {
				start = 1;
			}
			if (end > io.descr.d_nnote) {
				end = io.descr.d_nnote;	/* max out */
			}
			for (i = start; i <= end; i++) {
				getnrec (&io, i, &note);
				if (note.n_stat & DELETED) {
					continue;
					/* its not really there */
				}
				/* want page breaks? */
				if (singlepage && left != length) {
					pagebreak(lprfile);
				}
				lprnote(&io, lprfile, toc, i, &note);
			}
		}
	}
	x (fclose(toc) == EOF,
	    "nfprint: failed to close scratch file \"%s\"", fn);
	x ((toc = fopen(fn, "r")) == NULL,
	    "nfprint: couldn't reopen scratch file \"%s\"", fn);
	pagebreak(lprfile);			/* force a page break */
	while ((i = getc(toc)) != EOF)
		putc(i, lprfile);
	fclose(toc);
	x (unlink(fn) < 0,
	    "nfprint: couldn't unlink scratch file \"%s\"", fn);
	pclose(lprfile);				/* flush the pipe */
	exit(GOOD);
}

/*
 *	lprnote(io, lprfile, toc, notenum, note)
 *
 *	prints the specified note to lprfile, and makes an entry in
 *	toc file. Paging is taken care of and the page/line stuff is
 *	correctly set at the conclusion.
 *
 *	lprresp(io, lprfile, toc, respnum, rsprec, roffset)
 *
 *	Same as the lprnote routine. Works for responses though.
 *
 *	pagebreak(lprfile)
 *
 *	forces a page break.
 *
 *	Ray Essick	May 13, 1982
 */

#define	NOTENEED	7
#define	RESPNEED	7

lprnote(io, lprfile, toc, notenum, note)
struct io_f *io;
FILE * lprfile, *toc;
struct note_f  *note;
{
	struct resp_f rsprec;
	int roffset, rblock;
	int i;
	char auth[BUFLEN];
	char ztime[DATELEN];

	if (left < NOTENEED)		/* room for header and some text? */
		pagebreak (lprfile);		/* make it that way */

	sprdate(note->n_msg.m_subtime, ztime);	/* format date */

	fprintf(toc, "%3d%s", notenum, note->n_stat & DIRMES ? "*" : " ");
	gethdr(io, &note->n_msg, note->n_msg.m_from, auth);
	fprintf(toc, "%-25s %-15s %s %3d\n", note->n_title, auth, ztime, page);

	fprintf(lprfile, "\n====    ====    ====    ====    ====    ====    ====\n");
	fprintf(lprfile, "Note %-3d %s  ", notenum,
	note->n_stat & DIRMES ? "(*)" : "   ");
	fputs(note->n_title, lprfile);

	if (note->n_nresp)
		fprintf(lprfile, "   %d response%c", note->n_nresp,
		note->n_nresp > 1 ? 's' : ' ');
	putc('\n', lprfile);

	fprintf(lprfile, "%s  %s\n\n", auth, ztime);

	left -= 5;				/* count off the header lines */

	left -= pageout (io, &note->n_msg.m_addr, lprfile);    /* dump text */

	while (left < 0) {
		page++;
		left += length;
	}


	/* dump responses */
	for (i = 1; i <= note->n_nresp; i++) {
		if (lrsp(io, notenum, i, &rsprec, &roffset, &rblock) == -1)
			break;					/* bad chain */
		lprresp(io, lprfile, notenum, i, &rsprec.r_msg[roffset]);
	}
}

lprresp(io, lprfile, notenum, respnum, msgp)
struct io_f *io;
FILE *lprfile;
struct msg_f *msgp;
{
	char auth[BUFLEN];
	char ztime[DATELEN];

	if (left < RESPNEED) 			/* room on page? */
		pagebreak (lprfile);

	gethdr(io, msgp, msgp->m_from, auth);
	sprdate(msgp->m_subtime, ztime);
	fprintf(lprfile, "\n==== ==== ====\n");
	fprintf(lprfile, "Response %-4d to Note %-4d\n\t%s  %s\n\n",
	    respnum, notenum, auth, ztime);

	left -= 5;				/* count the header */

	left -= pageout(io, &msgp->m_addr, lprfile);

	while (left < 0) {
		page++;
		left += length;
	}
}

pagebreak(zfile)
FILE *zfile;
{
	while (left > 0) {
		left--;
		putc('\n', zfile);
	}
	page++;
	left = length;
}

usage (invokedas)
char *invokedas;
{
	fprintf (stderr, "Usage: %s [-lnn] [-p] notefile list\n", 
	    invokedas);
}
