/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/parseauth.c,v 2.0 89/04/16 00:59:12 gore Exp $ */

/*
 * parse a standard author string (RFC 822 subset),
 * and return the pieces.
 */
#include "parms.h"
#include "structs.h"

struct auth_f *
parseauth(s)
	char *s;
{
	register char *p;
	register char *namep;
	char *index();
	static char buf[BUFLEN];
	static struct auth_f auth;

	strcpy(buf, s);
	if (p = index(buf, '(')) {
		if (p > buf)
			p[-1] = 0;
		*p++ = 0;
		namep = buf;
		auth.a_comment = p;
		if (p = index(p, ')'))
			*p = 0;
	} else if (p = index(buf, '<')) {
		if (p > buf)
			p[-1] = 0;
		*p++ = 0;
		namep = p;
		auth.a_comment = buf;
		if (p = index(p, '>'))
			*p = 0;
	} else {
		namep = buf;
		auth.a_comment = "";
	}
	auth.a_name = namep;
	auth.a_sys = "";
	if (p = index(namep, '@')) {
		*p++ = 0;
		auth.a_sys = p;
	}
	return(&auth);
}

makeauth(auth, hostname, anon)
	char *auth;
	int anon;
{
	register char *p = auth;
	register char *q;
	char *getname(), *getrealname();

	sprintf(p, "%s@%s", getname(anon), hostname);
	q = getrealname(anon);
	if (q && *q) {
		p += strlen(p);
		sprintf(p, " (%s)", q);
	}
}
