/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/initenv.c,v 2.0 89/04/16 00:53:31 gore Exp $ */

/*
 * this file contains initialization code that is
 * common to all programs.
 */

#include "parms.h"
#include "structs.h"
#include <pwd.h>
/*#include <grp.h>*/
#ifndef	SYSV
#include <netdb.h>
#endif	SYSV

int     nrows = 24;				/* number of rows on screen */
int     ncols = 80;				/* width of screen */
int     intflag = 0;				/* DEL hit recently */
int	nindex  = NINDEX;			/* number of index lines */
int	msk;
int	globuid;
int	globgid;
int	notesuid;
int	notesgid;
char    this_system[SYSSZ];			/* system name */
char	mydomain[SYSSZ];
char	full_hostname[SYSSZ];
char	hostname_in_path[SYSSZ];
char	replyto_hostname[SYSSZ];
char	*replyto_address = NULL;
char	default_subm_addr[ADDRLEN];
char	address_canonizer[WDLEN];
char	myorg[NNLEN];
char	prompt_str[SYSSZ];
char	libdir[WDLEN];
char	spooldir[WDLEN];
char	archdir[WDLEN];
char	pager[WDLEN];
char	shell[WDLEN];
char	editor[WDLEN];
char	mailposter[WDLEN];
char	writeprog[WDLEN];
char	my_logname[NAMESZ];
char	my_realname[64];			/* too small? */
char	*myhome;
char	*myterm;
int	verbose_mode;
int	uucp_mailer;
int	group_timeout;
int	verbose_log;
int	manual_rmgroup;
int	manual_mod_change;
dumpfmt_t default_dump_format;
int	concise_quotes;
int	jump_over_xposts;
dumpfmt_t dmp_format;

/*
 * The following is cheap insurance; this way if we have only a binary
 * available, and you have to change the notes user name, you can using
 * the debugger.  Icky, but better than nothing.
 */
char notes_username[9] = NOTESUID;

char	*env_var;				/* temp for environment var */

char *mnames[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug",
	"Sep", "Oct", "Nov", "Dec"
};

initenv()
{
	struct passwd *pw;
	struct passwd *getpwnam(), *getpwuid();
	/*struct group *gp;*/
	/*struct group *getgrnam();*/
	struct hostent *hp;
	void   endpwent(), endgrent();
	char   path[1024];
	FILE  *fp;
	char  *p;
	char  *q;

	msk = umask(NOTESUMASK);

	/*
	 * Dynamically obtain notes uid and gid
	 */
	pw = getpwnam(notes_username);
	if (pw == (struct passwd *)NULL) {
		fprintf(stderr, "no such user: %s.\n", NOTESUID);
		cleanup();
	}
	notesuid = pw->pw_uid;
	notesgid = pw->pw_gid;
	/*
	 * find out my real user id.
	 * if root, run as the notes user
	 */
	globuid = getuid();
	globgid = getgid();
	if (globuid == 0) {
		globgid = notesgid;
		setgid(notesgid);
		globuid = notesuid;
		setuid(notesuid);
	}

#ifdef STARTLIBDIR
	/*
	 * We start out with a hard-coded LIBDIR.  This is probably
	 * because we are an NFS client site, and need to read our
	 * own config file before moving over to the hub site's LIBDIR.
	 */
	safecpy(libdir, STARTLIBDIR, WDLEN);

#else STARTLIBDIR

	/* use notes home directory for libdir */
	strcpy(libdir, pw->pw_dir);

#endif STARTLIBDIR

	/* get system name */
	gethostname(this_system, sizeof this_system);
	
	/* get defaults for domain, etc. */
	load_default_config();

#ifdef	notdef
	if ((hp = gethostbyname(system)) != NULL)
		strcpy(system, hp->h_name);
#endif

	/* get my login and real name */
	pw = getpwuid(globuid);
	if (pw == NULL) {
		/* could also proceed anonymously... */
		fprintf(stderr, "Who are you?\n");
		cleanup();
	}
	strcpy(my_logname, pw->pw_name);
	/*
	 * let's make my_realname the same was as sendmail (kind of)
	 */
	q = my_realname;
	p = pw->pw_gecos;
	if (*p == '*')
		p++;
	while (*p != '\0' && *p != ',' && *p != ';' && *p != '%') {
		if (*p == '&') {
			strcpy(q, my_logname);
			if ((*q >= 'a') && (*q <= 'z'))
				*q += 'A' - 'a';
			while (*q)
				q++;
			p++;
		} else {
			*q++ = *p++;
		}
	}
	*q = '\0';

	/*
	 * Get Various Environmental Variables:
	 * PAGER, SHELL, VISUAL or EDITOR, MAILPOSTER, WRITE,
	 * HOME, TERM
	 */
	if ((env_var = getenv("PAGER")) != NULL)
	    safecpy(pager, env_var, WDLEN);
	if ((env_var = getenv("SHELL")) != NULL)
	    safecpy(shell, env_var, WDLEN);
	if ((env_var = getenv("MAILPOSTER")) != NULL)
	    safecpy(mailposter, env_var, WDLEN);
	if ((env_var = getenv("WRITE")) != NULL)
	    safecpy(writeprog, env_var, WDLEN);
	if ((env_var = getenv("ORGANIZATION")) != NULL)
	    safecpy(myorg, env_var, NNLEN);

	if ((env_var = getenv("EDITOR")) != NULL)
	    safecpy(editor, env_var, WDLEN);
	if ((env_var = getenv("VISUAL")) != NULL)	/* overrules EDITOR */
	    safecpy(editor, env_var, WDLEN);
	if ((env_var = getenv("NFED")) != NULL)		/* overrules VISUAL */
	    safecpy(editor, env_var, WDLEN);

	myhome = getenv("HOME");
	myterm = getenv("TERM");

	/* free up those file decriptors! */
	endpwent();
	/*endgrent();*/
}
